/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.address;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.address.DependentPhoneNumberReader;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DependentPhoneNumber
extends Resource {
    private static final long serialVersionUID = 249031953071048L;
    private final PhoneNumber friendlyName;
    private final PhoneNumber phoneNumber;
    private final String lata;
    private final String rateCenter;
    private final BigDecimal latitude;
    private final BigDecimal longitude;
    private final String region;
    private final String postalCode;
    private final String isoCountry;
    private final String addressRequirements;
    private final Map<String, String> capabilities;

    public static DependentPhoneNumberReader reader(String accountSid, String addressSid) {
        return new DependentPhoneNumberReader(accountSid, addressSid);
    }

    public static DependentPhoneNumberReader reader(String addressSid) {
        return new DependentPhoneNumberReader(addressSid);
    }

    public static DependentPhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (DependentPhoneNumber)objectMapper.readValue(json, DependentPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DependentPhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (DependentPhoneNumber)objectMapper.readValue(json, DependentPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DependentPhoneNumber(@JsonProperty(value="friendly_name") PhoneNumber friendlyName, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="lata") String lata, @JsonProperty(value="rate_center") String rateCenter, @JsonProperty(value="latitude") BigDecimal latitude, @JsonProperty(value="longitude") BigDecimal longitude, @JsonProperty(value="region") String region, @JsonProperty(value="postal_code") String postalCode, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="address_requirements") String addressRequirements, @JsonProperty(value="capabilities") Map<String, String> capabilities) {
        this.friendlyName = friendlyName;
        this.phoneNumber = phoneNumber;
        this.lata = lata;
        this.rateCenter = rateCenter;
        this.latitude = latitude;
        this.longitude = longitude;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
        this.addressRequirements = addressRequirements;
        this.capabilities = capabilities;
    }

    public final PhoneNumber getFriendlyName() {
        return this.friendlyName;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getLata() {
        return this.lata;
    }

    public final String getRateCenter() {
        return this.rateCenter;
    }

    public final BigDecimal getLatitude() {
        return this.latitude;
    }

    public final BigDecimal getLongitude() {
        return this.longitude;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getPostalCode() {
        return this.postalCode;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final String getAddressRequirements() {
        return this.addressRequirements;
    }

    public final Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependentPhoneNumber other = (DependentPhoneNumber)o;
        return Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.lata, other.lata) && Objects.equals(this.rateCenter, other.rateCenter) && Objects.equals(this.latitude, other.latitude) && Objects.equals(this.longitude, other.longitude) && Objects.equals(this.region, other.region) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.addressRequirements, other.addressRequirements) && Objects.equals(this.capabilities, other.capabilities);
    }

    public int hashCode() {
        return Objects.hash(this.friendlyName, this.phoneNumber, this.lata, this.rateCenter, this.latitude, this.longitude, this.region, this.postalCode, this.isoCountry, this.addressRequirements, this.capabilities);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("friendlyName", (Object)this.friendlyName).add("phoneNumber", (Object)this.phoneNumber).add("lata", (Object)this.lata).add("rateCenter", (Object)this.rateCenter).add("latitude", (Object)this.latitude).add("longitude", (Object)this.longitude).add("region", (Object)this.region).add("postalCode", (Object)this.postalCode).add("isoCountry", (Object)this.isoCountry).add("addressRequirements", (Object)this.addressRequirements).add("capabilities", this.capabilities).toString();
    }
}

