/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.FeedbackSummaryCreator;
import com.twilio.rest.api.v2010.account.call.FeedbackSummaryDeleter;
import com.twilio.rest.api.v2010.account.call.FeedbackSummaryFetcher;
import com.twilio.type.FeedbackIssue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeedbackSummary
extends Resource {
    private static final long serialVersionUID = 167286727474638L;
    private final String accountSid;
    private final Integer callCount;
    private final Integer callFeedbackCount;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime endDate;
    private final Boolean includeSubaccounts;
    private final List<FeedbackIssue> issues;
    private final BigDecimal qualityScoreAverage;
    private final BigDecimal qualityScoreMedian;
    private final BigDecimal qualityScoreStandardDeviation;
    private final String sid;
    private final DateTime startDate;
    private final Status status;

    public static FeedbackSummaryCreator creator(String accountSid, LocalDate startDate, LocalDate endDate) {
        return new FeedbackSummaryCreator(accountSid, startDate, endDate);
    }

    public static FeedbackSummaryCreator creator(LocalDate startDate, LocalDate endDate) {
        return new FeedbackSummaryCreator(startDate, endDate);
    }

    public static FeedbackSummaryFetcher fetcher(String accountSid, String sid) {
        return new FeedbackSummaryFetcher(accountSid, sid);
    }

    public static FeedbackSummaryFetcher fetcher(String sid) {
        return new FeedbackSummaryFetcher(sid);
    }

    public static FeedbackSummaryDeleter deleter(String accountSid, String sid) {
        return new FeedbackSummaryDeleter(accountSid, sid);
    }

    public static FeedbackSummaryDeleter deleter(String sid) {
        return new FeedbackSummaryDeleter(sid);
    }

    public static FeedbackSummary fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (FeedbackSummary)objectMapper.readValue(json, FeedbackSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FeedbackSummary fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (FeedbackSummary)objectMapper.readValue(json, FeedbackSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FeedbackSummary(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_count") Integer callCount, @JsonProperty(value="call_feedback_count") Integer callFeedbackCount, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="end_date") String endDate, @JsonProperty(value="include_subaccounts") Boolean includeSubaccounts, @JsonProperty(value="issues") List<FeedbackIssue> issues, @JsonProperty(value="quality_score_average") BigDecimal qualityScoreAverage, @JsonProperty(value="quality_score_median") BigDecimal qualityScoreMedian, @JsonProperty(value="quality_score_standard_deviation") BigDecimal qualityScoreStandardDeviation, @JsonProperty(value="sid") String sid, @JsonProperty(value="start_date") String startDate, @JsonProperty(value="status") Status status) {
        this.accountSid = accountSid;
        this.callCount = callCount;
        this.callFeedbackCount = callFeedbackCount;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.endDate = DateConverter.iso8601DateTimeFromString(endDate);
        this.includeSubaccounts = includeSubaccounts;
        this.issues = issues;
        this.qualityScoreAverage = qualityScoreAverage;
        this.qualityScoreMedian = qualityScoreMedian;
        this.qualityScoreStandardDeviation = qualityScoreStandardDeviation;
        this.sid = sid;
        this.startDate = DateConverter.iso8601DateTimeFromString(startDate);
        this.status = status;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getCallCount() {
        return this.callCount;
    }

    public final Integer getCallFeedbackCount() {
        return this.callFeedbackCount;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getEndDate() {
        return this.endDate;
    }

    public final Boolean getIncludeSubaccounts() {
        return this.includeSubaccounts;
    }

    public final List<FeedbackIssue> getIssues() {
        return this.issues;
    }

    public final BigDecimal getQualityScoreAverage() {
        return this.qualityScoreAverage;
    }

    public final BigDecimal getQualityScoreMedian() {
        return this.qualityScoreMedian;
    }

    public final BigDecimal getQualityScoreStandardDeviation() {
        return this.qualityScoreStandardDeviation;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getStartDate() {
        return this.startDate;
    }

    public final Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedbackSummary other = (FeedbackSummary)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callCount, other.callCount) && Objects.equals(this.callFeedbackCount, other.callFeedbackCount) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endDate, other.endDate) && Objects.equals(this.includeSubaccounts, other.includeSubaccounts) && Objects.equals(this.issues, other.issues) && Objects.equals(this.qualityScoreAverage, other.qualityScoreAverage) && Objects.equals(this.qualityScoreMedian, other.qualityScoreMedian) && Objects.equals(this.qualityScoreStandardDeviation, other.qualityScoreStandardDeviation) && Objects.equals(this.sid, other.sid) && Objects.equals(this.startDate, other.startDate) && Objects.equals((Object)this.status, (Object)other.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.callCount, this.callFeedbackCount, this.dateCreated, this.dateUpdated, this.endDate, this.includeSubaccounts, this.issues, this.qualityScoreAverage, this.qualityScoreMedian, this.qualityScoreStandardDeviation, this.sid, this.startDate, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("callCount", (Object)this.callCount).add("callFeedbackCount", (Object)this.callFeedbackCount).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("endDate", (Object)this.endDate).add("includeSubaccounts", (Object)this.includeSubaccounts).add("issues", this.issues).add("qualityScoreAverage", (Object)this.qualityScoreAverage).add("qualityScoreMedian", (Object)this.qualityScoreMedian).add("qualityScoreStandardDeviation", (Object)this.qualityScoreStandardDeviation).add("sid", (Object)this.sid).add("startDate", (Object)this.startDate).add("status", (Object)this.status).toString();
    }

    public static enum Status {
        QUEUED("queued"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

