/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Feedback;
import java.util.List;

public class FeedbackUpdater
extends Updater<Feedback> {
    private String accountSid;
    private final String callSid;
    private final Integer qualityScore;
    private List<Feedback.Issues> issue;

    public FeedbackUpdater(String callSid, Integer qualityScore) {
        this.callSid = callSid;
        this.qualityScore = qualityScore;
    }

    public FeedbackUpdater(String accountSid, String callSid, Integer qualityScore) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.qualityScore = qualityScore;
    }

    public FeedbackUpdater setIssue(List<Feedback.Issues> issue) {
        this.issue = issue;
        return this;
    }

    public FeedbackUpdater setIssue(Feedback.Issues issue) {
        return this.setIssue(Promoter.listOfOne(issue));
    }

    @Override
    public Feedback update(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.callSid + "/Feedback.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Feedback update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Feedback.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.qualityScore != null) {
            request.addPostParam("QualityScore", this.qualityScore.toString());
        }
        if (this.issue != null) {
            for (Feedback.Issues prop : this.issue) {
                request.addPostParam("Issue", prop.toString());
            }
        }
    }
}

