/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.google.common.collect.Range;
import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Notification;
import org.joda.time.LocalDate;

public class NotificationReader
extends Reader<Notification> {
    private String accountSid;
    private final String callSid;
    private Integer log;
    private LocalDate absoluteMessageDate;
    private Range<LocalDate> rangeMessageDate;

    public NotificationReader(String callSid) {
        this.callSid = callSid;
    }

    public NotificationReader(String accountSid, String callSid) {
        this.accountSid = accountSid;
        this.callSid = callSid;
    }

    public NotificationReader setLog(Integer log) {
        this.log = log;
        return this;
    }

    public NotificationReader setMessageDate(LocalDate absoluteMessageDate) {
        this.rangeMessageDate = null;
        this.absoluteMessageDate = absoluteMessageDate;
        return this;
    }

    public NotificationReader setMessageDate(Range<LocalDate> rangeMessageDate) {
        this.absoluteMessageDate = null;
        this.rangeMessageDate = rangeMessageDate;
        return this;
    }

    @Override
    public ResourceSet<Notification> read(TwilioRestClient client) {
        return new ResourceSet<Notification>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Notification> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.callSid + "/Notifications.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Notification> nextPage(Page<Notification> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Notification> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("notifications", response.getContent(), Notification.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.log != null) {
            request.addQueryParam("Log", this.log.toString());
        }
        if (this.absoluteMessageDate != null) {
            request.addQueryParam("MessageDate", this.absoluteMessageDate.toString("yyyy-MM-dd"));
        } else if (this.rangeMessageDate != null) {
            request.addQueryDateRange("MessageDate", this.rangeMessageDate);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

