/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.Local;
import com.twilio.type.PhoneNumber;

public class LocalReader
extends Reader<Local> {
    private String ownerAccountSid;
    private Boolean beta;
    private String friendlyName;
    private PhoneNumber phoneNumber;

    public LocalReader() {
    }

    public LocalReader(String ownerAccountSid) {
        this.ownerAccountSid = ownerAccountSid;
    }

    public LocalReader setBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public LocalReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public LocalReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Override
    public ResourceSet<Local> read(TwilioRestClient client) {
        return new ResourceSet<Local>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Local> firstPage(TwilioRestClient client) {
        this.ownerAccountSid = this.ownerAccountSid == null ? client.getAccountSid() : this.ownerAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.ownerAccountSid + "/IncomingPhoneNumbers/Local.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Local> nextPage(Page<Local> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Local> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Local read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("incoming_phone_numbers", response.getContent(), Local.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

