/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.CredentialListCreator;
import com.twilio.rest.api.v2010.account.sip.CredentialListDeleter;
import com.twilio.rest.api.v2010.account.sip.CredentialListFetcher;
import com.twilio.rest.api.v2010.account.sip.CredentialListReader;
import com.twilio.rest.api.v2010.account.sip.CredentialListUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CredentialList
extends Resource {
    private static final long serialVersionUID = 214188792953524L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final Map<String, String> subresourceUris;
    private final String uri;

    public static CredentialListReader reader(String accountSid) {
        return new CredentialListReader(accountSid);
    }

    public static CredentialListReader reader() {
        return new CredentialListReader();
    }

    public static CredentialListCreator creator(String accountSid, String friendlyName) {
        return new CredentialListCreator(accountSid, friendlyName);
    }

    public static CredentialListCreator creator(String friendlyName) {
        return new CredentialListCreator(friendlyName);
    }

    public static CredentialListFetcher fetcher(String accountSid, String sid) {
        return new CredentialListFetcher(accountSid, sid);
    }

    public static CredentialListFetcher fetcher(String sid) {
        return new CredentialListFetcher(sid);
    }

    public static CredentialListUpdater updater(String accountSid, String sid, String friendlyName) {
        return new CredentialListUpdater(accountSid, sid, friendlyName);
    }

    public static CredentialListUpdater updater(String sid, String friendlyName) {
        return new CredentialListUpdater(sid, friendlyName);
    }

    public static CredentialListDeleter deleter(String accountSid, String sid) {
        return new CredentialListDeleter(accountSid, sid);
    }

    public static CredentialListDeleter deleter(String sid) {
        return new CredentialListDeleter(sid);
    }

    public static CredentialList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (CredentialList)objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CredentialList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (CredentialList)objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CredentialList(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.subresourceUris = subresourceUris;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialList other = (CredentialList)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.subresourceUris, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("subresourceUris", this.subresourceUris).add("uri", (Object)this.uri).toString();
    }
}

