/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.sip.DomainCreator;
import com.twilio.rest.api.v2010.account.sip.DomainDeleter;
import com.twilio.rest.api.v2010.account.sip.DomainFetcher;
import com.twilio.rest.api.v2010.account.sip.DomainReader;
import com.twilio.rest.api.v2010.account.sip.DomainUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Domain
extends Resource {
    private static final long serialVersionUID = 72982381631904L;
    private final String accountSid;
    private final String apiVersion;
    private final String authType;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String domainName;
    private final String friendlyName;
    private final String sid;
    private final String uri;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final HttpMethod voiceStatusCallbackMethod;
    private final URI voiceStatusCallbackUrl;
    private final URI voiceUrl;
    private final Map<String, String> subresourceUris;

    public static DomainReader reader(String accountSid) {
        return new DomainReader(accountSid);
    }

    public static DomainReader reader() {
        return new DomainReader();
    }

    public static DomainCreator creator(String accountSid, String domainName) {
        return new DomainCreator(accountSid, domainName);
    }

    public static DomainCreator creator(String domainName) {
        return new DomainCreator(domainName);
    }

    public static DomainFetcher fetcher(String accountSid, String sid) {
        return new DomainFetcher(accountSid, sid);
    }

    public static DomainFetcher fetcher(String sid) {
        return new DomainFetcher(sid);
    }

    public static DomainUpdater updater(String accountSid, String sid) {
        return new DomainUpdater(accountSid, sid);
    }

    public static DomainUpdater updater(String sid) {
        return new DomainUpdater(sid);
    }

    public static DomainDeleter deleter(String accountSid, String sid) {
        return new DomainDeleter(accountSid, sid);
    }

    public static DomainDeleter deleter(String sid) {
        return new DomainDeleter(sid);
    }

    public static Domain fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Domain)objectMapper.readValue(json, Domain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Domain fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Domain)objectMapper.readValue(json, Domain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Domain(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="auth_type") String authType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="domain_name") String domainName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_status_callback_method") HttpMethod voiceStatusCallbackMethod, @JsonProperty(value="voice_status_callback_url") URI voiceStatusCallbackUrl, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.authType = authType;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.domainName = domainName;
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.uri = uri;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceStatusCallbackMethod = voiceStatusCallbackMethod;
        this.voiceStatusCallbackUrl = voiceStatusCallbackUrl;
        this.voiceUrl = voiceUrl;
        this.subresourceUris = subresourceUris;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getAuthType() {
        return this.authType;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDomainName() {
        return this.domainName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final HttpMethod getVoiceStatusCallbackMethod() {
        return this.voiceStatusCallbackMethod;
    }

    public final URI getVoiceStatusCallbackUrl() {
        return this.voiceStatusCallbackUrl;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain other = (Domain)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.authType, other.authType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals((Object)this.voiceStatusCallbackMethod, (Object)other.voiceStatusCallbackMethod) && Objects.equals(this.voiceStatusCallbackUrl, other.voiceStatusCallbackUrl) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.authType, this.dateCreated, this.dateUpdated, this.domainName, this.friendlyName, this.sid, this.uri, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceStatusCallbackMethod, this.voiceStatusCallbackUrl, this.voiceUrl, this.subresourceUris});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("authType", (Object)this.authType).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("domainName", (Object)this.domainName).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("uri", (Object)this.uri).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceStatusCallbackMethod", (Object)this.voiceStatusCallbackMethod).add("voiceStatusCallbackUrl", (Object)this.voiceStatusCallbackUrl).add("voiceUrl", (Object)this.voiceUrl).add("subresourceUris", this.subresourceUris).toString();
    }
}

