/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.credentiallist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialCreator;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialDeleter;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialFetcher;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialReader;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Credential
extends Resource {
    private static final long serialVersionUID = 207131851434233L;
    private final String sid;
    private final String accountSid;
    private final String credentialListSid;
    private final String username;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static CredentialReader reader(String accountSid, String credentialListSid) {
        return new CredentialReader(accountSid, credentialListSid);
    }

    public static CredentialReader reader(String credentialListSid) {
        return new CredentialReader(credentialListSid);
    }

    public static CredentialCreator creator(String accountSid, String credentialListSid, String username, String password) {
        return new CredentialCreator(accountSid, credentialListSid, username, password);
    }

    public static CredentialCreator creator(String credentialListSid, String username, String password) {
        return new CredentialCreator(credentialListSid, username, password);
    }

    public static CredentialFetcher fetcher(String accountSid, String credentialListSid, String sid) {
        return new CredentialFetcher(accountSid, credentialListSid, sid);
    }

    public static CredentialFetcher fetcher(String credentialListSid, String sid) {
        return new CredentialFetcher(credentialListSid, sid);
    }

    public static CredentialUpdater updater(String accountSid, String credentialListSid, String sid) {
        return new CredentialUpdater(accountSid, credentialListSid, sid);
    }

    public static CredentialUpdater updater(String credentialListSid, String sid) {
        return new CredentialUpdater(credentialListSid, sid);
    }

    public static CredentialDeleter deleter(String accountSid, String credentialListSid, String sid) {
        return new CredentialDeleter(accountSid, credentialListSid, sid);
    }

    public static CredentialDeleter deleter(String credentialListSid, String sid) {
        return new CredentialDeleter(credentialListSid, sid);
    }

    public static Credential fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Credential)objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Credential fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Credential)objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Credential(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="credential_list_sid") String credentialListSid, @JsonProperty(value="username") String username, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.credentialListSid = credentialListSid;
        this.username = username;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCredentialListSid() {
        return this.credentialListSid;
    }

    public final String getUsername() {
        return this.username;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.credentialListSid, other.credentialListSid) && Objects.equals(this.username, other.username) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.credentialListSid, this.username, this.dateCreated, this.dateUpdated, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("credentialListSid", (Object)this.credentialListSid).add("username", (Object)this.username).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("uri", (Object)this.uri).toString();
    }
}

