/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMapping;

public class IpAccessControlListMappingCreator
extends Creator<IpAccessControlListMapping> {
    private String accountSid;
    private final String domainSid;
    private final String ipAccessControlListSid;

    public IpAccessControlListMappingCreator(String domainSid, String ipAccessControlListSid) {
        this.domainSid = domainSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    public IpAccessControlListMappingCreator(String accountSid, String domainSid, String ipAccessControlListSid) {
        this.accountSid = accountSid;
        this.domainSid = domainSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    @Override
    public IpAccessControlListMapping create(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains/" + this.domainSid + "/IpAccessControlListMappings.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlListMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return IpAccessControlListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipAccessControlListSid != null) {
            request.addPostParam("IpAccessControlListSid", this.ipAccessControlListSid);
        }
    }
}

