/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMapping;

public class IpAccessControlListMappingReader
extends Reader<IpAccessControlListMapping> {
    private String accountSid;
    private final String domainSid;

    public IpAccessControlListMappingReader(String domainSid) {
        this.domainSid = domainSid;
    }

    public IpAccessControlListMappingReader(String accountSid, String domainSid) {
        this.accountSid = accountSid;
        this.domainSid = domainSid;
    }

    @Override
    public ResourceSet<IpAccessControlListMapping> read(TwilioRestClient client) {
        return new ResourceSet<IpAccessControlListMapping>(this, client, this.firstPage(client));
    }

    @Override
    public Page<IpAccessControlListMapping> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains/" + this.domainSid + "/IpAccessControlListMappings.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpAccessControlListMapping> nextPage(Page<IpAccessControlListMapping> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<IpAccessControlListMapping> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlListMapping read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("ip_access_control_list_mappings", response.getContent(), IpAccessControlListMapping.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

