/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage.record;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.record.Monthly;
import org.joda.time.LocalDate;

public class MonthlyReader
extends Reader<Monthly> {
    private String accountSid;
    private Monthly.Category category;
    private LocalDate startDate;
    private LocalDate endDate;

    public MonthlyReader() {
    }

    public MonthlyReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public MonthlyReader setCategory(Monthly.Category category) {
        this.category = category;
        return this;
    }

    public MonthlyReader setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public MonthlyReader setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public ResourceSet<Monthly> read(TwilioRestClient client) {
        return new ResourceSet<Monthly>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Monthly> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Usage/Records/Monthly.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Monthly> nextPage(Page<Monthly> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Monthly> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Monthly read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("usage_records", response.getContent(), Monthly.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.category != null) {
            request.addQueryParam("Category", this.category.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", DateConverter.dateStringFromLocalDate(this.startDate));
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", DateConverter.dateStringFromLocalDate(this.endDate));
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

