/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v1.service.user.UserChannelReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserChannel
extends Resource {
    private static final long serialVersionUID = 158542275357573L;
    private final String accountSid;
    private final String serviceSid;
    private final String channelSid;
    private final String memberSid;
    private final ChannelStatus status;
    private final Integer lastConsumedMessageIndex;
    private final Integer unreadMessagesCount;
    private final Map<String, String> links;

    public static UserChannelReader reader(String serviceSid, String userSid) {
        return new UserChannelReader(serviceSid, userSid);
    }

    public static UserChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (UserChannel)objectMapper.readValue(json, UserChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (UserChannel)objectMapper.readValue(json, UserChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="member_sid") String memberSid, @JsonProperty(value="status") ChannelStatus status, @JsonProperty(value="last_consumed_message_index") Integer lastConsumedMessageIndex, @JsonProperty(value="unread_messages_count") Integer unreadMessagesCount, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.channelSid = channelSid;
        this.memberSid = memberSid;
        this.status = status;
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        this.unreadMessagesCount = unreadMessagesCount;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getMemberSid() {
        return this.memberSid;
    }

    public final ChannelStatus getStatus() {
        return this.status;
    }

    public final Integer getLastConsumedMessageIndex() {
        return this.lastConsumedMessageIndex;
    }

    public final Integer getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserChannel other = (UserChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.memberSid, other.memberSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.lastConsumedMessageIndex, other.lastConsumedMessageIndex) && Objects.equals(this.unreadMessagesCount, other.unreadMessagesCount) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.serviceSid, this.channelSid, this.memberSid, this.status, this.lastConsumedMessageIndex, this.unreadMessagesCount, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("channelSid", (Object)this.channelSid).add("memberSid", (Object)this.memberSid).add("status", (Object)this.status).add("lastConsumedMessageIndex", (Object)this.lastConsumedMessageIndex).add("unreadMessagesCount", (Object)this.unreadMessagesCount).add("links", this.links).toString();
    }

    public static enum ChannelStatus {
        JOINED("joined"),
        INVITED("invited"),
        NOT_PARTICIPATING("not_participating");

        private final String value;

        private ChannelStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelStatus forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return ChannelStatus.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

