/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v1.service.RoleCreator;
import com.twilio.rest.ipmessaging.v1.service.RoleDeleter;
import com.twilio.rest.ipmessaging.v1.service.RoleFetcher;
import com.twilio.rest.ipmessaging.v1.service.RoleReader;
import com.twilio.rest.ipmessaging.v1.service.RoleUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Role
extends Resource {
    private static final long serialVersionUID = 136946012216407L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String friendlyName;
    private final RoleType type;
    private final List<String> permissions;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static RoleFetcher fetcher(String serviceSid, String sid) {
        return new RoleFetcher(serviceSid, sid);
    }

    public static RoleDeleter deleter(String serviceSid, String sid) {
        return new RoleDeleter(serviceSid, sid);
    }

    public static RoleCreator creator(String serviceSid, String friendlyName, RoleType type, List<String> permission) {
        return new RoleCreator(serviceSid, friendlyName, type, permission);
    }

    public static RoleReader reader(String serviceSid) {
        return new RoleReader(serviceSid);
    }

    public static RoleUpdater updater(String serviceSid, String sid, List<String> permission) {
        return new RoleUpdater(serviceSid, sid, permission);
    }

    public static Role fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Role)objectMapper.readValue(json, Role.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Role fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Role)objectMapper.readValue(json, Role.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Role(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="type") RoleType type, @JsonProperty(value="permissions") List<String> permissions, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.permissions = permissions;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final RoleType getType() {
        return this.type;
    }

    public final List<String> getPermissions() {
        return this.permissions;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role other = (Role)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.friendlyName, this.type, this.permissions, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("friendlyName", (Object)this.friendlyName).add("type", (Object)this.type).add("permissions", this.permissions).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }

    public static enum RoleType {
        CHANNEL("channel"),
        DEPLOYMENT("deployment");

        private final String value;

        private RoleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoleType forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return RoleType.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

