/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelFetcher;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskChannel
extends Resource {
    private static final long serialVersionUID = 123017740799311L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String uniqueName;
    private final String workspaceSid;
    private final URI url;

    public static TaskChannelFetcher fetcher(String workspaceSid, String sid) {
        return new TaskChannelFetcher(workspaceSid, sid);
    }

    public static TaskChannelReader reader(String workspaceSid) {
        return new TaskChannelReader(workspaceSid);
    }

    public static TaskChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (TaskChannel)objectMapper.readValue(json, TaskChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (TaskChannel)objectMapper.readValue(json, TaskChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskChannel other = (TaskChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.uniqueName, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

