/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.ReservationFetcher;
import com.twilio.rest.taskrouter.v1.workspace.worker.ReservationReader;
import com.twilio.rest.taskrouter.v1.workspace.worker.ReservationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Reservation
extends Resource {
    private static final long serialVersionUID = 156834658396048L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Status reservationStatus;
    private final String sid;
    private final String taskSid;
    private final String workerName;
    private final String workerSid;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static ReservationReader reader(String workspaceSid, String workerSid) {
        return new ReservationReader(workspaceSid, workerSid);
    }

    public static ReservationFetcher fetcher(String workspaceSid, String workerSid, String sid) {
        return new ReservationFetcher(workspaceSid, workerSid, sid);
    }

    public static ReservationUpdater updater(String workspaceSid, String workerSid, String sid) {
        return new ReservationUpdater(workspaceSid, workerSid, sid);
    }

    public static Reservation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Reservation)objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Reservation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Reservation)objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Reservation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="reservation_status") Status reservationStatus, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="worker_name") String workerName, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.reservationStatus = reservationStatus;
        this.sid = sid;
        this.taskSid = taskSid;
        this.workerName = workerName;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Status getReservationStatus() {
        return this.reservationStatus;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final String getWorkerName() {
        return this.workerName;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reservation other = (Reservation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals((Object)this.reservationStatus, (Object)other.reservationStatus) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.workerName, other.workerName) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.reservationStatus, this.sid, this.taskSid, this.workerName, this.workerSid, this.workspaceSid, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("reservationStatus", (Object)this.reservationStatus).add("sid", (Object)this.sid).add("taskSid", (Object)this.taskSid).add("workerName", (Object)this.workerName).add("workerSid", (Object)this.workerSid).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum Status {
        PENDING("pending"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        TIMEOUT("timeout"),
        CANCELED("canceled"),
        RESCINDED("rescinded");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

