/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkerStatistics
extends Resource {
    private static final long serialVersionUID = 174560494604680L;
    private final String accountSid;
    private final Map<String, Object> cumulative;
    private final String workerSid;
    private final String workspaceSid;
    private final URI url;

    public static WorkerStatisticsFetcher fetcher(String workspaceSid, String workerSid) {
        return new WorkerStatisticsFetcher(workspaceSid, workerSid);
    }

    public static WorkerStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkerStatistics)objectMapper.readValue(json, WorkerStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkerStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkerStatistics)objectMapper.readValue(json, WorkerStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkerStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerStatistics other = (WorkerStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.workerSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("cumulative", this.cumulative).add("workerSid", (Object)this.workerSid).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

