/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class InboundCallPrice {
    private final double basePrice;
    private final double currentPrice;
    private final Type type;

    @JsonCreator
    public InboundCallPrice(@JsonProperty(value="base_price") double basePrice, @JsonProperty(value="current_price") double currentPrice, @JsonProperty(value="number_type") Type type) {
        this.basePrice = basePrice;
        this.currentPrice = currentPrice;
        this.type = type;
    }

    public double getBasePrice() {
        return this.basePrice;
    }

    public double getCurrentPrice() {
        return this.currentPrice;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundCallPrice other = (InboundCallPrice)o;
        return this.getBasePrice() == other.getBasePrice() && this.getCurrentPrice() == other.getCurrentPrice() && this.getType() == other.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basePrice, this.currentPrice, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("base_price", this.basePrice).add("current_price", this.currentPrice).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        LOCAL("local"),
        MOBILE("mobile"),
        NATIONAL("national"),
        TOLLFREE("toll free");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return value == null ? null : Type.valueOf(value.toUpperCase());
        }
    }
}

