/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.featurehandler;

import com.pingidentity.pingfederate.migration.featurehandler.XmlConfigFeatureHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EmailSettingHandler
extends XmlConfigFeatureHandler {
    private static final Logger log = LogManager.getLogger(EmailSettingHandler.class);
    public final String filePath = "/server/default/data/config-store/org.sourceid.saml20.domain.mgmt.impl.NotificationManager.xml";

    public EmailSettingHandler(String sourceRootDir) {
        this.fullFilePath = sourceRootDir + "/server/default/data/config-store/org.sourceid.saml20.domain.mgmt.impl.NotificationManager.xml";
    }

    @Override
    public void checkFeature() {
        try {
            Node smtpServerNode = this.query("/config/item[@name='SMTPServer']");
            if (smtpServerNode != null && StringUtils.isNotBlank((String)smtpServerNode.getTextContent())) {
                log.info("A defined Email Configuration has been detected, the configuration has been migrated to the \"System > Notification Publishers\" screen, as an instance configuration of the SMTP Notification Publisher.");
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            // empty catch block
        }
    }
}

