/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapAdapterCustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(FilesUtils.class);

    public LdapAdapterCustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        try {
            if (this.isSourceConfiguredToUseLdapAdapter()) {
                log.error("At least one configured LDAP Java IdP Adapter has been detected in your source PingFederate server.  As of PingFederate 7.2 this adapter is no longer supported and this adapter is no longer compatible with version PingFederate 12.2 or later. The configuration will need to be updated in your source PingFederate server to replace all instances of the LDAP Java IdP Adapter with new instances of the LDAP Password Credential Validator and HTML Form or HTTP Basic IdP Adapters. Proceeding without updating the configuration will result in unexpected behavior with the admin console.");
            }
        }
        catch (IOException ioe) {
            throw new FileCustomActionException("Unable to determine if the LDAP adapter exists at " + sourceDefaultFileParentDir + File.separator + fileName, (Throwable)ioe);
        }
    }

    private boolean isSourceConfiguredToUseLdapAdapter() throws IOException {
        boolean sourceConfiguredToUseLdapAdapter = false;
        File sourceAdapterManagerImplFile = new File(PingFederateDirectoryInfo.getInstance().getSourceConfigStoreDir(), "org.sourceid.saml20.domain.mgmt.impl.AdapterManagerImpl.xml");
        if (sourceAdapterManagerImplFile.exists()) {
            String sourceAdapterManagerImplAsString = FileUtils.readFileToString((File)sourceAdapterManagerImplFile);
            sourceConfiguredToUseLdapAdapter = sourceAdapterManagerImplAsString.contains("com.pingidentity.adapters.ldap.idp.LdapIdpAuthnAdapter") || sourceAdapterManagerImplAsString.contains("com.pingidentity.adapters.ldap.sp.LdapSpAuthnAdapter");
        }
        return sourceConfiguredToUseLdapAdapter;
    }
}

