/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UsernameTokenProcessorCustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(UsernameTokenProcessorCustomAction.class);

    public UsernameTokenProcessorCustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        try {
            File sourceUtpJar = new File(sourceFileParentDir, fileName);
            FilesUtils.copyfile((File)sourceUtpJar, (File)new File(destinationFileParentDir, fileName));
            log.warn("An earlier version of the Username Token Processor was detected in your source PingFederate server. As of PingFederate 7.2, this version is deprecated. To avoid impacting the existing configuration, the deprecated version has been copied to the destination PingFederate server. Please see the Upgrade Utility documentation for information on how to migrate to the new, integrated version of this plugin.");
        }
        catch (IOException ioe) {
            throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName, (Throwable)ioe);
        }
    }
}

