/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.propertyfile;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.pingfederate.migration.file.PropertyFileMigrator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguagePackPropertyFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(LanguagePackPropertyFileCustomAction.class);
    private final PropertyFileMigrator propertyFileMigrator;
    private final String defaultFileName;
    private final String sourcePFVersion;

    public LanguagePackPropertyFileCustomAction(PropertyFileMigrator propertyFileMigrator, String defaultFileName, String sourcePFVersion) {
        this.propertyFileMigrator = propertyFileMigrator;
        this.defaultFileName = defaultFileName;
        this.sourcePFVersion = sourcePFVersion;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block11: {
            File sourceFile = new File(sourceFileParentDir, fileName);
            File destinationFile = new File(destinationFileParentDir, fileName);
            try {
                if (!sourceFile.exists()) {
                    log.debug("File not migrated: " + LogHelper.getInstance().getCleanPath(sourceFile) + ". File does not exist.");
                    break block11;
                }
                if (!destinationFile.exists()) {
                    if (!this.propertyFileMigrator.isDefaultFile(sourceDefaultFileParentDir, this.defaultFileName)) {
                        log.warn("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " is not a recognized PingFederate language pack file.");
                        break block11;
                    }
                    File destinationBaseFile = new File(destinationFileParentDir, this.defaultFileName);
                    try {
                        FileUtils.copyFile((File)destinationBaseFile, (File)destinationFile);
                    }
                    catch (IOException e) {
                        log.error("Unable to copy file " + LogHelper.getInstance().getCleanPath(sourceFile) + " to " + LogHelper.getInstance().getCleanPath(destinationFile), (Throwable)e);
                    }
                    this.propertyFileMigrator.merge(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, this.defaultFileName);
                    break block11;
                }
                if (!this.propertyFileMigrator.isDefaultFile(sourceDefaultFileParentDir, this.defaultFileName)) {
                    log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " was not expected.");
                } else if (!this.propertyFileMigrator.isFilesEqual(sourceFile, destinationFile)) {
                    this.propertyFileMigrator.merge(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
                } else {
                    log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " is equal to " + LogHelper.getInstance().getCleanPath(destinationFile));
                }
            }
            catch (FileMigrationException e) {
                log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(destinationFile), (Throwable)e);
            }
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    protected PropertyFileMigrator getPropertyFileMigrator() {
        return this.propertyFileMigrator;
    }

    protected String getDefaultFileName() {
        return this.defaultFileName;
    }

    protected String getSourcePFVersion() {
        return this.sourcePFVersion;
    }
}

