/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.migrator;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingcommons.upgrade.file.PropertyAppender;
import com.pingidentity.pingfederate.migration.AdminRolePropertyName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdminRolePropertyAppender
implements PropertyAppender {
    private static final Logger log = LogManager.getLogger(AdminRolePropertyAppender.class);
    private final String sourceVersion;
    private final AdminRolePropertyName adminRolePropertyNames;

    public AdminRolePropertyAppender(AdminRolePropertyName adminRolePropertyNames, String sourceVersion) {
        this.adminRolePropertyNames = adminRolePropertyNames;
        this.sourceVersion = sourceVersion;
    }

    public Map<String, String> getPropertiesToAppend(Properties sourceProperties, String fileName) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        try {
            if (Version.compare((String)this.sourceVersion, (String)"10.1.0") < 0) {
                newProperties.putAll(this.getExpressionAdminRoleProperties(sourceProperties));
            }
            if (Version.compare((String)this.sourceVersion, (String)"12.2.0") < 0) {
                newProperties.putAll(this.getDataCollectionRoleMapProperties(sourceProperties));
            }
        }
        catch (MigrationException e) {
            log.warn("Unable to append admin role properties for file " + fileName + ". " + e.getMessage());
        }
        for (Map.Entry entry : newProperties.entrySet()) {
            log.info("Append property " + (String)entry.getKey() + " in " + fileName + ": " + LogHelper.getInstance().getValueForLog((String)entry.getKey(), entry.getValue()) + ".");
        }
        return newProperties;
    }

    private Map<String, String> getExpressionAdminRoleProperties(Properties sourceProperties) {
        String adminRoleGroupName = this.adminRolePropertyNames.getAdminRoleGroup();
        String eaRoleGroupName = this.adminRolePropertyNames.getEaRoleGroup();
        HashMap<String, String> eaRoleMap = new HashMap<String, String>();
        int i = 1;
        StringBuilder adminRoleWithIndex = new StringBuilder(adminRoleGroupName + "." + i);
        while (sourceProperties.getProperty(adminRoleWithIndex.toString()) != null) {
            String adminRoleNameWithIndex = adminRoleWithIndex.toString();
            if (!"role.expressionAdmin.subject".equals(eaRoleGroupName) || i != 1) {
                String eaRoleNameWithIndex = eaRoleGroupName + "." + i;
                String value = sourceProperties.getProperty(adminRoleNameWithIndex);
                eaRoleMap.put(eaRoleNameWithIndex, value);
            }
            adminRoleWithIndex = new StringBuilder(adminRoleGroupName + "." + ++i);
        }
        return eaRoleMap;
    }

    private Map<String, String> getDataCollectionRoleMapProperties(Properties sourceProperties) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        List<String> adminNames = this.getNamesForRole(this.adminRolePropertyNames.getAdminRoleGroup(), sourceProperties);
        List<String> userAdminNames = this.getNamesForRole(this.adminRolePropertyNames.getUserAdminRoleGroup(), sourceProperties);
        List<String> cryptoAdminNames = this.getNamesForRole(this.adminRolePropertyNames.getCryptoRoleGroup(), sourceProperties);
        List adminsWithAllRoles = adminNames.stream().distinct().filter(userAdminNames::contains).filter(cryptoAdminNames::contains).collect(Collectors.toList());
        for (int i = 0; i < adminsWithAllRoles.size(); ++i) {
            newProperties.put(this.adminRolePropertyNames.getDcRoleGroup() + "." + (i + 1), (String)adminsWithAllRoles.get(i));
        }
        return newProperties;
    }

    public List<String> getNamesForRole(String roleName, Properties sourceProperties) {
        ArrayList<String> roles = new ArrayList<String>();
        sourceProperties.stringPropertyNames().stream().filter(name -> name.startsWith(roleName)).filter(name -> StringUtils.isNotEmpty((String)sourceProperties.getProperty((String)name))).forEach(name -> roles.add(sourceProperties.getProperty((String)name)));
        return roles;
    }
}

