/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.connection.template.google;

import com.pingidentity.common.util.Closer;
import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.templates.connection.ConnectionTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RegExValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.util.api.ConnectionDeserializer;
import org.sourceid.util.license.LicenseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleTemplate
implements ConnectionTemplate {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(this.getClass());
    public static final String GOOGLE_TEMPLATE_ID = "Google";
    public static final String GOOGLE_TEMPLATE_DESCRIPTION = "Google Apps";
    private static final String GOOGLE_CONNECTION = "com/pingidentity/connection/template/google/xml/google-connection.xml";
    private static final String DOMAIN_NAME = "_DOMAIN-NAME";
    private static final String GOOGLE_ENTITY_ID = "google.com";
    private static final String GOOGLE_ENTITY_ID_FOR_SPECIFIC_ISSUER_PREFIX = "google.com/a/";
    private List<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
    private static String FIELD_DOMAIN = "Google Domain";
    private static String FIELD_DOMAIN_ISSUER = "DomainIssuer";
    private static String FIELD_DOMAIN_ISSUER_DESC = "Use a domain specific issuer";

    public GoogleTemplate() {
        TextFieldDescriptor domainName = new TextFieldDescriptor(FIELD_DOMAIN, FIELD_DOMAIN);
        RequiredFieldValidator requiredValidator = new RequiredFieldValidator();
        domainName.addValidator((FieldValidator)requiredValidator);
        Pattern domainPattern = Pattern.compile("[a-zA-Z0-9.-]+");
        RegExValidator regexValidator = new RegExValidator(domainPattern);
        domainName.addValidator((FieldValidator)regexValidator, true);
        this.fieldDescriptors.add((FieldDescriptor)domainName);
        CheckBoxFieldDescriptor checkbox = new CheckBoxFieldDescriptor(FIELD_DOMAIN_ISSUER, FIELD_DOMAIN_ISSUER_DESC);
        this.fieldDescriptors.add((FieldDescriptor)checkbox);
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public String getId() {
        return GOOGLE_TEMPLATE_ID;
    }

    public String getDescription() {
        return GOOGLE_TEMPLATE_DESCRIPTION;
    }

    public ConnectionBase getConnection(SimpleFieldList fieldList) {
        SpConnection googleConnection = null;
        try {
            ConnectionDeserializer deserializer = this.getConnectionDeserializer();
            if (deserializer != null) {
                List problems = deserializer.getProblems();
                if (problems.isEmpty()) {
                    googleConnection = (SpConnection)deserializer.getConnection();
                } else {
                    this.log.error((Object)("Unable to load Google Connection Template: " + problems.toString()));
                }
                String fieldDomainValue = fieldList.getFieldValue(FIELD_DOMAIN).toLowerCase();
                if (fieldList.getBooleanFieldValue(FIELD_DOMAIN_ISSUER)) {
                    googleConnection.setEntityId(GOOGLE_ENTITY_ID_FOR_SPECIFIC_ISSUER_PREFIX + fieldDomainValue);
                } else {
                    googleConnection.setEntityId(GOOGLE_ENTITY_ID);
                }
                Endpoint endpoint = googleConnection.getAssertionConsumerServiceEndpoint(Integer.valueOf(0));
                String location = endpoint.getLocation();
                endpoint.setLocation(location.replaceAll(DOMAIN_NAME, fieldDomainValue));
                if (LicenseManager.isSaasProvisioningEnabled() && ProvisionerManager.getProvisionerGlobalSettings().isEnabledInGui()) {
                    ProvisionerConfig provisionerConfig = new ProvisionerConfig(googleConnection.getEntityId());
                    googleConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisionerConfig);
                }
            }
        }
        catch (InvalidXmlException e) {
            this.log.error((Object)("Unable to load Google Connection Template: " + e.getMessage()));
        }
        catch (XmlException e) {
            this.log.error((Object)("Unable to load Google Connection Template: " + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to load Google Connection Template: " + e.getMessage()));
        }
        return googleConnection;
    }

    public String getNote() {
        return null;
    }

    private ConnectionDeserializer getConnectionDeserializer() throws InvalidXmlException, XmlException, IOException {
        ConnectionDeserializer deserializer = null;
        Enumeration<URL> resources = null;
        InputStream googleInputStream = null;
        try {
            Object content;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            resources = classLoader.getResources(GOOGLE_CONNECTION);
            URL url = resources.nextElement();
            if (resources.hasMoreElements()) {
                this.log.warn((Object)"Multiple xml template files detected. Loading the first found. (com/pingidentity/connection/template/google/xml/google-connection.xml)");
            }
            if ((content = url.getContent()) instanceof InputStream) {
                googleInputStream = (InputStream)content;
                deserializer = new ConnectionDeserializer(googleInputStream);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            Closer.close(googleInputStream);
        }
        return deserializer;
    }

    public List<String> checkPrerequisites() {
        return null;
    }
}

