/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.google;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.client.appsforyourdomain.AppsForYourDomainQuery;
import com.google.gdata.client.appsforyourdomain.AppsGroupsService;
import com.google.gdata.client.appsforyourdomain.NicknameService;
import com.google.gdata.client.appsforyourdomain.UserService;
import com.google.gdata.data.Extension;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainErrorCode;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.Login;
import com.google.gdata.data.appsforyourdomain.Name;
import com.google.gdata.data.appsforyourdomain.Nickname;
import com.google.gdata.data.appsforyourdomain.Quota;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.data.appsforyourdomain.generic.GenericFeed;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameEntry;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameFeed;
import com.google.gdata.data.appsforyourdomain.provisioning.UserEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.pingidentity.crypto.Password;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsExtension;
import com.pingidentity.provisioner.saas.SaasValidationException;
import com.pingidentity.provisioner.saas.google.GoogleException;
import com.pingidentity.provisioner.store.UserUpdater;
import com.pingidentity.provisioner.util.UserActivityLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.EmailValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GooglePlugin
extends BaseSaasPlugin
implements SaasProvisionerPluginGroupsExtension {
    private static Logger _logger = Logger.getLogger(GooglePlugin.class);
    private static Logger _userLogger = UserActivityLogger.getLogger();
    private static final String PASSWORD_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789`~!@#$%^&*()_+-=[]\\;',./{}|:\"<>?";
    private static final int PASSWORD_LENGTH = 15;
    private static final String SERVICE_VERSION = "2.0";
    private static final String SERVICE_URL_ROOT = System.getProperty("GooglePlugin.service.url.root", "https://www.google.com/a/feeds/");
    private static String IDENTITY_ATTRIBUTE_GROUPS = "emailLists";
    private Random _random = new Random(new Date().getTime());
    private String _applicationName = "PingFederate";
    private String _adminEmail;
    private String _adminPassword;
    private String _adminUsername;
    private String _domain;
    private Map<String, String> existingGoogleGroups;
    private String _baseServiceUrl;
    private UserService _userService;
    private NicknameService _nicknameService;
    private AppsGroupsService _appsGroupsService;

    public GooglePlugin() {
        this.setSaasUsernameFieldCode("username");
    }

    public List<FieldDescriptor> getParameterDescriptors() {
        ArrayList<FieldDescriptor> _descriptors = new ArrayList<FieldDescriptor>(2);
        TextFieldDescriptor emailDescriptor = new TextFieldDescriptor("adminEmail", "Admin Email");
        emailDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        emailDescriptor.addValidator((FieldValidator)new EmailValidator());
        TextFieldDescriptor passwordDescriptor = new TextFieldDescriptor("adminPassword", "Admin Password", true);
        passwordDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        _descriptors.add((FieldDescriptor)emailDescriptor);
        _descriptors.add((FieldDescriptor)passwordDescriptor);
        return _descriptors;
    }

    public void setParameters(FieldList fieldList) {
        super.setParameters(fieldList);
        this._adminEmail = fieldList.getFieldValue("adminEmail");
        this._adminPassword = new Password(fieldList.getFieldValue("adminPassword")).getStrValue();
    }

    protected SaasIdentity doGetUser(SaasIdentity identity) throws SaasException {
        String username = this.trimDomain(identity.hasGuid() ? identity.getGuid() : identity.getName());
        try {
            UserEntry userEntry = (UserEntry)this._userService.getEntry(this.createUserServiceUrl(username), UserEntry.class);
            Login login = userEntry.getLogin();
            Name name = userEntry.getName();
            Quota quota = userEntry.getQuota();
            SaasIdentity existingIdentity = new SaasIdentity("username");
            existingIdentity.putValues("givenName", name.getGivenName(), new String[0]);
            existingIdentity.putValues("familyName", name.getFamilyName(), new String[0]);
            existingIdentity.putValues("username", login.getUserName(), new String[0]);
            existingIdentity.putValues("admin", Boolean.toString(login.getAdmin()), new String[0]);
            existingIdentity.putValues("agreed", Boolean.toString(login.getAgreedToTerms()), new String[0]);
            existingIdentity.putValues("changePassword", Boolean.toString(login.getChangePasswordAtNextLogin()), new String[0]);
            existingIdentity.putValues("ipWhiteListed", Boolean.toString(login.getIpWhitelisted()), new String[0]);
            existingIdentity.putValues("passwordHash", login.getHashFunctionName(), new String[0]);
            existingIdentity.putValues("quota", quota.getLimit().toString(), new String[0]);
            existingIdentity.putValues("nicknames", this.retrieveNicknames(login.getUserName()));
            existingIdentity.putValues(IDENTITY_ATTRIBUTE_GROUPS, this.retrieveGroupsList(login.getUserName()));
            existingIdentity.setSaasGuid(login.getUserName());
            Boolean suspended = login.getSuspended();
            existingIdentity.setInProvisioningGroup(suspended == false);
            existingIdentity.setAccountEnabled(suspended == false);
            return existingIdentity;
        }
        catch (Exception e) {
            if (e instanceof AppsForYourDomainException) {
                AppsForYourDomainException appsException = (AppsForYourDomainException)e;
                if (AppsForYourDomainErrorCode.EntityDoesNotExist.equals((Object)appsException.getErrorCode())) {
                    return null;
                }
                if (AppsForYourDomainErrorCode.UserDeletedRecently.equals((Object)appsException.getErrorCode())) {
                    _logger.error((Object)("Trying to retrieve recently deleted user: " + username), (Throwable)e);
                    return null;
                }
            }
            throw new GoogleException("Cannot retrieve user: " + username, e);
        }
    }

    private void addUserToGroup(String username, Collection<String> groupsList) throws GoogleException {
        if (groupsList != null) {
            for (String groupName : groupsList) {
                if (this.googleGroupExists(groupName)) {
                    try {
                        this._appsGroupsService.addMemberToGroup(groupName, username);
                        continue;
                    }
                    catch (Exception e) {
                        throw new GoogleException("Cannot add: " + username + " to group: " + groupName, e);
                    }
                }
                _logger.debug((Object)("User " + username + " was not added to group " + groupName + ". Group does not exist."));
            }
        }
    }

    private synchronized boolean googleGroupExists(String groupId) throws GoogleException {
        if (this.existingGoogleGroups == null) {
            this.existingGoogleGroups = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                GenericFeed googleGroupsFeed = this._appsGroupsService.retrieveAllGroups();
                for (GenericEntry genericEntry : googleGroupsFeed.getEntries()) {
                    String exitingGroupId = (String)genericEntry.getAllProperties().get("groupId");
                    try {
                        exitingGroupId = this.trimDomain(exitingGroupId);
                    }
                    catch (SaasException saasEx) {
                        // empty catch block
                    }
                    String exitingGroupName = (String)genericEntry.getAllProperties().get("groupName");
                    this.existingGoogleGroups.put(exitingGroupId, exitingGroupName);
                }
            }
            catch (Exception ex) {
                throw new GoogleException("Uanble to retrieve a list of existing Google groups.", ex);
            }
        }
        return this.existingGoogleGroups.containsKey(groupId);
    }

    private synchronized void removeGroupFromExistingGroupsMap(String groupId) throws GoogleException {
        if (this.googleGroupExists(groupId)) {
            this.existingGoogleGroups.remove(groupId);
        }
    }

    private synchronized void addGroupToExistingGroupsMap(String groupId, String groupName) throws GoogleException {
        if (!this.googleGroupExists(groupId)) {
            this.existingGoogleGroups.put(groupId, groupName);
        }
    }

    private void addNicknames(String username, Collection<String> nicknames) throws GoogleException {
        if (nicknames != null) {
            for (String nickname : nicknames) {
                if (StringUtils.isEmpty((String)nickname) || nickname.equals(username)) continue;
                NicknameEntry nicknameEntry = new NicknameEntry();
                Nickname nicknameExt = new Nickname();
                nicknameExt.setName(nickname);
                nicknameEntry.addExtension((Extension)nicknameExt);
                Login login = new Login();
                login.setUserName(username);
                nicknameEntry.addExtension((Extension)login);
                try {
                    this._nicknameService.insert(this.createNicknameServiceUrl(null), (IEntry)nicknameEntry);
                }
                catch (Exception e) {
                    throw new GoogleException("Cannot add nickname: " + nickname + " to user: " + username, e);
                }
            }
        }
    }

    private Set<String> retrieveGroupsList(String username) throws IOException, ServiceException {
        HashSet<String> groupsListForUser = new HashSet<String>();
        GenericFeed groupsFeedForUser = this._appsGroupsService.retrieveGroups(username, true);
        for (GenericEntry groupEntry : groupsFeedForUser.getEntries()) {
            groupsListForUser.add((String)groupEntry.getAllProperties().get("groupName"));
        }
        return groupsListForUser;
    }

    private Set<String> retrieveNicknames(String username) throws IOException, ServiceException {
        HashSet<String> nicknames = new HashSet<String>();
        AppsForYourDomainQuery query = new AppsForYourDomainQuery(this.createNicknameServiceUrl(null));
        query.setUsername(username);
        NicknameFeed nicknameFeed = (NicknameFeed)this._nicknameService.query((Query)query, NicknameFeed.class);
        for (NicknameEntry nicknameEntry : nicknameFeed.getEntries()) {
            nicknames.add(nicknameEntry.getNickname().getName());
        }
        return nicknames;
    }

    private void deleteNickname(String nickname) throws IOException, ServiceException {
        this._nicknameService.delete(this.createNicknameServiceUrl(nickname));
    }

    private void removeUserFromGroup(String group, String username) throws IOException, ServiceException {
        this._appsGroupsService.deleteMemberFromGroup(group, username);
    }

    protected void doUpdateUser(SaasIdentity updatedIdentity, SaasIdentity existingIdentity, UserUpdater userUpdater) throws SaasException {
        String userGUID;
        boolean suspended;
        UserEntry userEntry = new UserEntry();
        String username = this.trimDomain(updatedIdentity.getName());
        boolean bl = suspended = !updatedIdentity.isActive();
        if (this._adminUsername.equalsIgnoreCase(username) && suspended) {
            throw new SaasException("Cannot suspend admin account!");
        }
        Login login = new Login();
        login.setUserName(username);
        login.setSuspended(Boolean.valueOf(suspended));
        if (updatedIdentity.hasUpdateValue("password")) {
            if (updatedIdentity.hasUpdateValue("passwordHash")) {
                login.setHashFunctionName(updatedIdentity.getValue("passwordHash"));
            }
            login.setPassword(updatedIdentity.getValue("password"));
        }
        if (updatedIdentity.hasUpdateValue("admin")) {
            login.setAdmin(Boolean.valueOf("true".equals(updatedIdentity.getValue("admin"))));
        }
        if (updatedIdentity.hasUpdateValue("agreed")) {
            login.setAgreedToTerms(Boolean.valueOf("true".equals(updatedIdentity.getValue("agreed"))));
        }
        if (updatedIdentity.hasUpdateValue("changePassword")) {
            login.setChangePasswordAtNextLogin(Boolean.valueOf("true".equals(updatedIdentity.getValue("changePassword"))));
        }
        if (updatedIdentity.hasUpdateValue("ipWhiteListed")) {
            login.setIpWhitelisted(Boolean.valueOf("true".equals(updatedIdentity.getValue("ipWhiteListed"))));
        }
        userEntry.addExtension((Extension)login);
        Name name = new Name();
        if (updatedIdentity.hasUpdateValue("givenName")) {
            name.setGivenName(updatedIdentity.getValue("givenName"));
        }
        if (updatedIdentity.hasUpdateValue("familyName")) {
            name.setFamilyName(updatedIdentity.getValue("familyName"));
        }
        if (updatedIdentity.hasUpdateValue("givenName") || updatedIdentity.hasUpdateValue("familyName")) {
            userEntry.addExtension((Extension)name);
        }
        if (updatedIdentity.hasUpdateValue("quota")) {
            Quota quota = new Quota();
            quota.setLimit(Integer.valueOf(Integer.parseInt(updatedIdentity.getValue("quota"))));
            userEntry.addExtension((Extension)quota);
        }
        List updatedIdentityNicknames = Collections.emptyList();
        if (updatedIdentity.hasUpdateValue("nicknames")) {
            updatedIdentityNicknames = updatedIdentity.getValues("nicknames");
        }
        HashSet<String> nicknamesToAdd = new HashSet<String>();
        HashSet nicknamesToDelete = new HashSet(existingIdentity.getValues("nicknames"));
        for (String nickname : updatedIdentityNicknames) {
            if (existingIdentity.getValues("nicknames").contains(nickname)) {
                nicknamesToDelete.remove(nickname);
                continue;
            }
            nicknamesToAdd.add(nickname);
        }
        this.addNicknames(username, nicknamesToAdd);
        for (String nickname : nicknamesToDelete) {
            try {
                this.deleteNickname(nickname);
            }
            catch (Exception e) {
                throw new SaasException("Cannot delete nickname: " + nickname + ", username: " + username, (Throwable)e);
            }
        }
        List updatedIdentityGroups = Collections.emptyList();
        if (updatedIdentity.hasUpdateValue(IDENTITY_ATTRIBUTE_GROUPS)) {
            updatedIdentityGroups = updatedIdentity.getValues(IDENTITY_ATTRIBUTE_GROUPS);
        }
        HashSet<String> add = new HashSet<String>();
        HashSet del = new HashSet(existingIdentity.getValues(IDENTITY_ATTRIBUTE_GROUPS));
        for (String group : updatedIdentityGroups) {
            if (existingIdentity.getValues(IDENTITY_ATTRIBUTE_GROUPS).contains(group)) {
                del.remove(group);
                continue;
            }
            add.add(group);
        }
        this.addUserToGroup(username, add);
        for (String group : del) {
            try {
                this.removeUserFromGroup(group, username);
            }
            catch (Exception e) {
                throw new SaasException("Cannot remove user from email list: " + group + ", username: " + username, (Throwable)e);
            }
        }
        if (updatedIdentity.hasGuid() && !(userGUID = updatedIdentity.getGuid()).equals(username)) {
            if (this._adminUsername.equalsIgnoreCase(userGUID)) {
                throw new SaasException("Cannot rename admin account!");
            }
            _userLogger.info((Object)("Renaming: " + userGUID + " to " + username));
            throw new SaasException("Renaming account from " + userGUID + " to " + username + " not supported!");
        }
        try {
            this._userService.update(this.createUserServiceUrl(username), (IEntry)userEntry);
            _userLogger.debug((Object)("Account suspended: " + (suspended ? "true" : "false")));
            if (!updatedIdentity.hasGuid()) {
                _userLogger.debug((Object)("Set ASP User GUID: " + username));
                userUpdater.setSaasGuid(username);
            }
            userUpdater.clearDirtyFlag();
            _userLogger.info((Object)("Updated: " + username));
        }
        catch (Exception e) {
            throw new GoogleException("Cannot update user: " + username, e);
        }
    }

    protected void doCreateUser(SaasIdentity identity, UserUpdater userUpdater) throws SaasException {
        UserEntry userEntry = new UserEntry();
        String firstName = identity.getValue("givenName");
        String lastName = identity.getValue("familyName");
        String username = this.trimDomain(identity.getName());
        boolean suspended = !identity.isActive();
        Login login = new Login();
        login.setUserName(username);
        login.setSuspended(Boolean.valueOf(suspended));
        if (identity.hasValue("password")) {
            if (identity.hasValue("passwordHash")) {
                login.setHashFunctionName(identity.getValue("passwordHash"));
            }
            login.setPassword(identity.getValue("password"));
        } else {
            login.setPassword(this.randomPassword());
        }
        if (identity.hasValue("admin")) {
            login.setAdmin(Boolean.valueOf("true".equals(identity.getValue("admin"))));
        }
        if (identity.hasValue("agreed")) {
            login.setAgreedToTerms(Boolean.valueOf("true".equals(identity.getValue("agreed"))));
        }
        if (identity.hasValue("changePassword")) {
            login.setChangePasswordAtNextLogin(Boolean.valueOf("true".equals(identity.getValue("changePassword"))));
        }
        if (identity.hasValue("ipWhiteListed")) {
            login.setIpWhitelisted(Boolean.valueOf("true".equals(identity.getValue("ipWhiteListed"))));
        }
        userEntry.addExtension((Extension)login);
        Name name = new Name();
        name.setGivenName(firstName);
        name.setFamilyName(lastName);
        userEntry.addExtension((Extension)name);
        if (identity.hasValue("quota")) {
            Quota quota = new Quota();
            quota.setLimit(Integer.valueOf(Integer.parseInt(identity.getValue("quota"))));
            userEntry.addExtension((Extension)quota);
        }
        try {
            this._userService.insert(this.createUserServiceUrl(null), (IEntry)userEntry);
            if (identity.hasGuid()) {
                _logger.error((Object)("New user should not have a userGUID, overwriting with new username: " + username));
            }
            userUpdater.setSaasGuid(username);
            userUpdater.clearDirtyFlag();
            _userLogger.info((Object)("Created: " + username));
        }
        catch (Exception e) {
            throw new GoogleException("Cannot create user: " + username, e);
        }
        this.addNicknames(username, identity.getValues("nicknames"));
        this.addUserToGroup(username, identity.getValues(IDENTITY_ATTRIBUTE_GROUPS));
    }

    protected Properties loadDefaultMappings() throws IOException {
        Properties defaultMappings = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        defaultMappings.load(classLoader.getResourceAsStream("com/pingidentity/provisioner/saas/google/mappings.default.properties"));
        return defaultMappings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLoadFieldsInfo() throws SaasException {
        try {
            List fieldInfos = FieldInfo.parseFieldsInfo((String)"com/pingidentity/provisioner/saas/google/fields.properties");
            if (this._adminEmail == null) throw new SaasException("Admin Email must be set before requesting fields info!");
            FieldInfo fieldInfo = new FieldInfo("username", "Username");
            if (!fieldInfos.contains(fieldInfo)) throw new SaasException("Expected to find field: username");
            String regex = (fieldInfo = (FieldInfo)fieldInfos.get(fieldInfos.indexOf(fieldInfo))).getRegEx();
            if (regex.indexOf("{0}") == -1) throw new SaasException("username regex must contain a message pattern: " + regex);
            String domain = this.keepDomain(this._adminEmail);
            if (domain.indexOf("\\E") != -1) {
                throw new SaasException("Domain cannot be escaped because it contains \\E:" + domain);
            }
            regex = StringUtils.replace((String)regex, (String)"{0}", (String)("\\Q" + domain + "\\E"));
            fieldInfo.setRegEx(regex);
            this.setFieldInfos(fieldInfos);
            return;
        }
        catch (IOException e) {
            throw new SaasException("Cannot parse fields information!", (Throwable)e);
        }
    }

    public boolean doesGroupExist(String groupName) throws SaasException {
        return this.googleGroupExists(groupName);
    }

    public void createGroup(SaasGroup saasGroup) throws SaasException {
        try {
            this._appsGroupsService.createGroup(saasGroup.getGuid(), saasGroup.getName(), "", "");
            this.addGroupToExistingGroupsMap(saasGroup.getGuid(), saasGroup.getName());
        }
        catch (AppsForYourDomainException e) {
            throw new SaasException("Unable to create group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new SaasException("Unable to create group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SaasException("Unable to create group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (ServiceException e) {
            throw new SaasException("Unable to create group: " + saasGroup.getName(), (Throwable)e);
        }
    }

    public void deleteGroup(SaasGroup saasGroup) throws SaasException {
        try {
            this._appsGroupsService.deleteGroup(saasGroup.getGuid());
            this.removeGroupFromExistingGroupsMap(saasGroup.getGuid());
        }
        catch (AppsForYourDomainException e) {
            throw new SaasException("Unable to delete group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new SaasException("Unable to delete group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SaasException("Unable to delete group: " + saasGroup.getName(), (Throwable)e);
        }
        catch (ServiceException e) {
            throw new SaasException("Unable to delete group: " + saasGroup.getName(), (Throwable)e);
        }
    }

    public SaasGroup getGroup(SaasGroup saasGroup) throws SaasException {
        return null;
    }

    public void updateGroup(SaasGroup saasGroup) throws SaasException {
        _logger.warn((Object)("Attempting to update a group (" + saasGroup.getName() + ") but there is nothing to update. Clearing dirty flag."));
    }

    public void startSession() throws SaasException {
        try {
            this._domain = this.keepDomain(this._adminEmail);
            this._baseServiceUrl = SERVICE_URL_ROOT + this._domain + "/";
            this._adminUsername = this.trimDomain(this._adminEmail);
            this._userService = new UserService(this._applicationName);
            this._nicknameService = new NicknameService(this._applicationName);
            this._appsGroupsService = new AppsGroupsService(this._adminEmail, this._adminPassword, this._domain, this._applicationName);
            this.doLogin();
        }
        catch (AuthenticationException e) {
            throw new SaasException("Cannot authenticate!", (Throwable)e);
        }
        super.startSession();
    }

    private void doLogin() throws AuthenticationException, SaasException {
        try {
            this._userService.setUserCredentials(this._adminEmail, this._adminPassword);
            this._nicknameService.setUserCredentials(this._adminEmail, this._adminPassword);
            this.validateAccount();
            _logger.debug((Object)("Successful login to Google: " + this._adminEmail));
        }
        catch (GoogleService.CaptchaRequiredException e) {
            _logger.error((Object)("Captcha challenge! Unlock at: https://www.google.com/a/" + this._domain + "/UnlockCaptcha. " + "(token: " + e.getCaptchaToken() + " URL: " + e.getCaptchaUrl() + ")"));
            throw e;
        }
    }

    public void checkSession() throws SaasException {
        try {
            this._userService.getEntry(this.createUserServiceUrl(this._adminUsername), UserEntry.class);
        }
        catch (Exception e) {
            _logger.info((Object)"Renewing session ID...", (Throwable)e);
            try {
                this.doLogin();
            }
            catch (AuthenticationException e1) {
                throw new SaasException("Cannot login to user service!", (Throwable)e);
            }
        }
    }

    private void validateAccount() throws SaasException {
        UserEntry userEntry;
        try {
            userEntry = (UserEntry)this._userService.getEntry(this.createUserServiceUrl(this._adminUsername), UserEntry.class);
        }
        catch (Exception e) {
            throw new SaasException("Cannot retrieve admin account: " + this._adminUsername, (Throwable)e);
        }
        Login login = userEntry.getLogin();
        if (!login.getAdmin().booleanValue()) {
            throw new SaasValidationException("User not an administrator: " + this._adminUsername);
        }
    }

    private String keepDomain(String email) throws SaasException {
        int idxAt = email.indexOf(64);
        if (idxAt == -1) {
            throw new SaasException("Admin email address does not have a domain: " + email);
        }
        return email.substring(idxAt + 1);
    }

    private String trimDomain(String username) throws SaasException {
        if (username.indexOf(64) > -1) {
            if (username.endsWith("@" + this._domain)) {
                return username.substring(0, username.length() - 1 - this._domain.length());
            }
            throw new SaasException("Domain mismatch for username: " + username + " Expected: " + this._domain);
        }
        return username;
    }

    private String randomPassword() {
        StringBuffer password = new StringBuffer(15);
        for (int i = 0; i < 15; ++i) {
            password.append(PASSWORD_CHARS.charAt(this._random.nextInt(PASSWORD_CHARS.length())));
        }
        return password.toString();
    }

    private URL createUserServiceUrl(String username) throws MalformedURLException {
        String url = this._baseServiceUrl + "user/" + SERVICE_VERSION;
        if (username != null) {
            url = url + "/" + username;
        }
        return new URL(url);
    }

    private URL createNicknameServiceUrl(String nickname) throws MalformedURLException {
        String url = this._baseServiceUrl + "nickname/" + SERVICE_VERSION;
        if (nickname != null) {
            url = url + "/" + nickname;
        }
        return new URL(url);
    }

    public String getId() {
        return "Google";
    }

    public int getDefaultMaxThreads() {
        return 40;
    }

    public String getDescription() {
        return "Google Apps";
    }
}

