/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class Address {
    public static final AttributeValueResolver<Address> ADDRESS_RESOLVER = new AttributeValueResolver<Address>(){

        @Override
        public Address toInstance(SCIMAttributeValue value) {
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            return new Address((String)value.getSubAttributeValue("formatted", STRING_RESOLVER), (String)value.getSubAttributeValue("streetAddress", STRING_RESOLVER), (String)value.getSubAttributeValue("locality", STRING_RESOLVER), (String)value.getSubAttributeValue("region", STRING_RESOLVER), (String)value.getSubAttributeValue("postalCode", STRING_RESOLVER), (String)value.getSubAttributeValue("country", STRING_RESOLVER), (String)value.getSubAttributeValue("type", STRING_RESOLVER), p == null ? false : p);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor addressDescriptor, Address value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(8);
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.formatted != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("formatted"), SCIMAttributeValue.createStringValue(value.formatted)));
            }
            if (value.streetAddress != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("streetAddress"), SCIMAttributeValue.createStringValue(value.streetAddress)));
            }
            if (value.locality != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("locality"), SCIMAttributeValue.createStringValue(value.locality)));
            }
            if (value.region != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("region"), SCIMAttributeValue.createStringValue(value.region)));
            }
            if (value.postalCode != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("postalCode"), SCIMAttributeValue.createStringValue(value.postalCode)));
            }
            if (value.country != null) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("country"), SCIMAttributeValue.createStringValue(value.country)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(addressDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private String country;
    private String formatted;
    private String locality;
    private String postalCode;
    private String region;
    private String streetAddress;
    private String type;
    private boolean primary;

    public Address(String formatted, String streetAddress, String locality, String region, String postalCode, String country, String type, boolean primary) {
        this.country = country;
        this.formatted = formatted;
        this.locality = locality;
        this.postalCode = postalCode;
        this.primary = primary;
        this.region = region;
        this.streetAddress = streetAddress;
        this.type = type;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public void setFormatted(String formatted) {
        this.formatted = formatted;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.primary != address.primary) {
            return false;
        }
        if (this.country != null ? !this.country.equals(address.country) : address.country != null) {
            return false;
        }
        if (this.formatted != null ? !this.formatted.equals(address.formatted) : address.formatted != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(address.locality) : address.locality != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(address.region) : address.region != null) {
            return false;
        }
        if (this.streetAddress != null ? !this.streetAddress.equals(address.streetAddress) : address.streetAddress != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(address.type) : address.type != null);
    }

    public int hashCode() {
        int result = this.country != null ? this.country.hashCode() : 0;
        result = 31 * result + (this.formatted != null ? this.formatted.hashCode() : 0);
        result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.streetAddress != null ? this.streetAddress.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Address{formatted='" + this.formatted + '\'' + ", streetAddress='" + this.streetAddress + '\'' + ", locality='" + this.locality + '\'' + ", region='" + this.region + '\'' + ", postalCode='" + this.postalCode + '\'' + ", country='" + this.country + '\'' + ", type='" + this.type + '\'' + ", primary=" + this.primary + '}';
    }
}

