/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class Meta {
    public static final AttributeValueResolver<Meta> META_RESOLVER = new AttributeValueResolver<Meta>(){

        @Override
        public Meta toInstance(SCIMAttributeValue value) {
            String l = (String)value.getSubAttributeValue("location", STRING_RESOLVER);
            Meta meta = new Meta((Date)value.getSubAttributeValue("created", DATE_RESOLVER), (Date)value.getSubAttributeValue("lastModified", DATE_RESOLVER), l == null ? null : URI.create(l), (String)value.getSubAttributeValue("version", STRING_RESOLVER));
            Collection<String> diagInfoValues = value.getSubAttributeValues("__diagnostic_info", STRING_RESOLVER);
            if (diagInfoValues != null) {
                meta.setDiagnosticInfo(diagInfoValues.toArray(new String[diagInfoValues.size()]));
            }
            return meta;
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Meta value) throws InvalidResourceException {
            AttributeDescriptor subAttributeDescriptor;
            ArrayList<SCIMAttribute> attributes = new ArrayList<SCIMAttribute>(3);
            if (value.created != null) {
                subAttributeDescriptor = attributeDescriptor.getSubAttribute("created");
                attributes.add(SCIMAttribute.create(subAttributeDescriptor, SCIMAttributeValue.createDateValue(value.created)));
            }
            if (value.lastModified != null) {
                subAttributeDescriptor = attributeDescriptor.getSubAttribute("lastModified");
                attributes.add(SCIMAttribute.create(subAttributeDescriptor, SCIMAttributeValue.createDateValue(value.lastModified)));
            }
            if (value.location != null) {
                subAttributeDescriptor = attributeDescriptor.getSubAttribute("location");
                attributes.add(SCIMAttribute.create(subAttributeDescriptor, SCIMAttributeValue.createStringValue(value.location.toString())));
            }
            if (value.version != null) {
                subAttributeDescriptor = attributeDescriptor.getSubAttribute("version");
                attributes.add(SCIMAttribute.create(subAttributeDescriptor, SCIMAttributeValue.createStringValue(value.version)));
            }
            if (value.diagnosticInfo != null && value.diagnosticInfo.length > 0) {
                SCIMAttributeValue[] diagInfoValues = new SCIMAttributeValue[value.diagnosticInfo.length];
                for (int i = 0; i < value.diagnosticInfo.length; ++i) {
                    diagInfoValues[i] = SCIMAttributeValue.createStringValue(value.diagnosticInfo[i]);
                }
                AttributeDescriptor subAttributeDescriptor2 = attributeDescriptor.getSubAttribute("__diagnostic_info");
                attributes.add(SCIMAttribute.create(subAttributeDescriptor2, diagInfoValues));
            }
            return SCIMAttributeValue.createComplexValue(attributes);
        }
    };
    private Date created;
    private Date lastModified;
    private URI location;
    private String version;
    private String[] diagnosticInfo;

    public Meta(Date created, Date lastModified, URI location, String version) {
        this.created = created;
        this.lastModified = lastModified;
        this.location = location;
        this.version = version;
        this.diagnosticInfo = new String[0];
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    public void setDiagnosticInfo(String[] diagnosticInfo) {
        this.diagnosticInfo = diagnosticInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meta meta = (Meta)o;
        if (this.created != null ? !this.created.equals(meta.created) : meta.created != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(meta.lastModified) : meta.lastModified != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(meta.location) : meta.location != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(meta.version) : meta.version != null);
    }

    public int hashCode() {
        int result = this.created != null ? this.created.hashCode() : 0;
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Meta{created=" + this.created + ", lastModified=" + this.lastModified + ", location=" + this.location + ", version='" + this.version + '\'' + '}';
    }
}

