/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class Name {
    public static final AttributeValueResolver<Name> NAME_RESOLVER = new AttributeValueResolver<Name>(){

        @Override
        public Name toInstance(SCIMAttributeValue value) {
            return new Name((String)value.getSubAttributeValue("formatted", STRING_RESOLVER), (String)value.getSubAttributeValue("familyName", STRING_RESOLVER), (String)value.getSubAttributeValue("middleName", STRING_RESOLVER), (String)value.getSubAttributeValue("givenName", STRING_RESOLVER), (String)value.getSubAttributeValue("honorificPrefix", STRING_RESOLVER), (String)value.getSubAttributeValue("honorificSuffix", STRING_RESOLVER));
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Name value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(6);
            if (value.formatted != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("formatted"), SCIMAttributeValue.createStringValue(value.formatted)));
            }
            if (value.givenName != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("givenName"), SCIMAttributeValue.createStringValue(value.givenName)));
            }
            if (value.familyName != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("familyName"), SCIMAttributeValue.createStringValue(value.familyName)));
            }
            if (value.middleName != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("middleName"), SCIMAttributeValue.createStringValue(value.middleName)));
            }
            if (value.honorificPrefix != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("honorificPrefix"), SCIMAttributeValue.createStringValue(value.honorificPrefix)));
            }
            if (value.honorificSuffix != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("honorificSuffix"), SCIMAttributeValue.createStringValue(value.honorificSuffix)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private String formatted;
    private String familyName;
    private String middleName;
    private String givenName;
    private String honorificPrefix;
    private String honorificSuffix;

    public Name(String formatted, String familyName, String middleName, String givenName, String honorificPrefix, String honorificSuffix) {
        this.formatted = formatted;
        this.familyName = familyName;
        this.middleName = middleName;
        this.givenName = givenName;
        this.honorificPrefix = honorificPrefix;
        this.honorificSuffix = honorificSuffix;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public void setFormatted(String formatted) {
        this.formatted = formatted;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name = (Name)o;
        if (this.familyName != null ? !this.familyName.equals(name.familyName) : name.familyName != null) {
            return false;
        }
        if (this.formatted != null ? !this.formatted.equals(name.formatted) : name.formatted != null) {
            return false;
        }
        if (this.givenName != null ? !this.givenName.equals(name.givenName) : name.givenName != null) {
            return false;
        }
        if (this.honorificPrefix != null ? !this.honorificPrefix.equals(name.honorificPrefix) : name.honorificPrefix != null) {
            return false;
        }
        if (this.honorificSuffix != null ? !this.honorificSuffix.equals(name.honorificSuffix) : name.honorificSuffix != null) {
            return false;
        }
        return !(this.middleName != null ? !this.middleName.equals(name.middleName) : name.middleName != null);
    }

    public int hashCode() {
        int result = this.formatted != null ? this.formatted.hashCode() : 0;
        result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
        result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
        result = 31 * result + (this.honorificPrefix != null ? this.honorificPrefix.hashCode() : 0);
        result = 31 * result + (this.honorificSuffix != null ? this.honorificSuffix.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Name{formatted='" + this.formatted + '\'' + ", familyName='" + this.familyName + '\'' + ", middleName='" + this.middleName + '\'' + ", givenName='" + this.givenName + '\'' + ", honorificPrefix='" + this.honorificPrefix + '\'' + ", honorificSuffix='" + this.honorificSuffix + '\'' + '}';
    }
}

