/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.facade.org.apache.wink.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponse {
    private Response response;

    ClientResponse(Response response) {
        this.response = response;
    }

    public <T> T getEntity(Class<T> entityClass) {
        Object entity = this.response.readEntity(entityClass);
        if (entity instanceof InputStream) {
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int readLength;
                do {
                    if ((readLength = ((InputStream)entity).read(buffer)) <= 0) continue;
                    bos.write(buffer, 0, readLength);
                } while (readLength != -1);
                return (T)new ByteArrayInputStream(bos.toByteArray());
            }
            catch (IOException ex) {
                throw new RuntimeException("Caught exception trying to read entity.", ex);
            }
        }
        return (T)entity;
    }

    public Response.Status getStatusType() {
        return Response.Status.fromStatusCode((int)this.response.getStatus());
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public String getMessage() {
        return this.response.getStatusInfo().getReasonPhrase();
    }

    public void consumeContent() throws IOException {
        InputStream inputStream = this.getEntity(InputStream.class);
        try {
            while (inputStream.read(new byte[512]) != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.response.getStringHeaders();
    }

    public void close() {
        if (this.response != null) {
            this.response.close();
        }
    }
}

