/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.facade.org.apache.wink.client;

import com.unboundid.scim.facade.org.apache.wink.client.ClientResponse;
import com.unboundid.scim.facade.org.apache.wink.client.ClientWebException;
import com.unboundid.scim.facade.org.apache.wink.client.RestClient;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private WebTarget webTarget;
    private MediaType contentType;
    private MediaType acceptType;
    private MultivaluedMap<String, Object> headers;
    private Cookie cookie;

    Resource(RestClient restClient, URI uri) {
        Client client = restClient.getClient();
        this.webTarget = client.target(uri);
        this.headers = new MultivaluedHashMap();
        this.contentType = MediaType.APPLICATION_JSON_TYPE;
    }

    public Resource accept(MediaType acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    public Resource accept(String acceptTypeString) {
        this.acceptType = MediaType.valueOf((String)acceptTypeString);
        return this;
    }

    public Resource contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public Resource cookie(String cookie) {
        this.cookie = Cookie.valueOf((String)cookie);
        return this;
    }

    public Resource cookie(Cookie cookie) {
        this.cookie = cookie;
        return this;
    }

    public Resource contentType(String contentTypeString) {
        this.contentType = MediaType.valueOf((String)contentTypeString);
        return this;
    }

    public Resource header(String name, String ... values) {
        this.headers.addAll((Object)name, (Object[])values);
        return this;
    }

    public Resource queryParam(String name, Object ... values) {
        this.webTarget = this.webTarget.queryParam(name, values);
        return this;
    }

    public ClientResponse options() {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.options();
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }

    public ClientResponse get() {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.get();
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }

    public ClientResponse post(Object entity) throws ClientWebException {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.post(Entity.entity((Object)entity, (MediaType)this.contentType));
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }

    public <T> ClientResponse put(T entity) {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.put(Entity.entity(entity, (MediaType)this.contentType));
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }

    public ClientResponse delete() {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.delete();
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }

    public <T> ClientResponse invoke(String operation, Class<ClientResponse> responseClass, T entity) throws ClientWebException {
        Invocation.Builder builder = this.webTarget.request();
        builder.headers(this.headers);
        if (this.acceptType != null) {
            builder.accept(new MediaType[]{this.acceptType});
        }
        if (this.cookie != null) {
            builder.cookie(this.cookie);
        }
        Response response = builder.method(operation, Entity.entity(entity, (MediaType)this.contentType));
        ClientResponse clientResponse = new ClientResponse(response);
        return clientResponse;
    }
}

