/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.schema;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.Entry;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeDescriptor {
    public static final AttributeValueResolver<AttributeDescriptor> ATTRIBUTE_DESCRIPTOR_RESOLVER = new AttributeDescriptorResolver(false);
    private final String schema;
    private final String name;
    private final String description;
    private final boolean readOnly;
    private final boolean required;
    private final boolean multiValued;
    private final String multiValuedChildName;
    private final boolean caseExact;
    private final DataType dataType;
    private final Map<String, AttributeDescriptor> subAttributes;
    private final Collection<Entry<String>> canonicalValues;

    private AttributeDescriptor(String name, DataType dataType, boolean multiValued, String multiValuedChildName, String description, String schema, boolean readOnly, boolean required, boolean caseExact, Collection<Entry<String>> canonicalValues, Collection<AttributeDescriptor> subAttributes) {
        this.name = name;
        this.dataType = dataType;
        this.multiValued = multiValued;
        this.multiValuedChildName = multiValuedChildName;
        this.description = description;
        this.schema = schema;
        this.readOnly = readOnly;
        this.required = required;
        this.caseExact = caseExact;
        this.canonicalValues = canonicalValues != null && !canonicalValues.isEmpty() ? canonicalValues : null;
        if (subAttributes != null && !subAttributes.isEmpty()) {
            this.subAttributes = new LinkedHashMap<String, AttributeDescriptor>(subAttributes.size());
            for (AttributeDescriptor attributeDescriptor : subAttributes) {
                this.subAttributes.put(StaticUtils.toLowerCase(attributeDescriptor.getName()), attributeDescriptor);
            }
        } else {
            this.subAttributes = null;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String getMultiValuedChildName() {
        return this.multiValuedChildName;
    }

    public Collection<AttributeDescriptor> getSubAttributes() {
        Map<String, AttributeDescriptor> allSubAttributes = CoreSchema.addNormativeSubAttributes(this, this.subAttributes);
        return allSubAttributes == null ? null : allSubAttributes.values();
    }

    public Collection<AttributeDescriptor> getDeclaredSubAttributes() {
        return this.subAttributes == null ? null : this.subAttributes.values();
    }

    public AttributeDescriptor getSubAttribute(String externalName) throws InvalidResourceException {
        AttributeDescriptor subAttribute;
        Map<String, AttributeDescriptor> allSubAttributes = CoreSchema.addNormativeSubAttributes(this, this.subAttributes);
        AttributeDescriptor attributeDescriptor = subAttribute = allSubAttributes == null ? null : allSubAttributes.get(StaticUtils.toLowerCase(externalName));
        if (subAttribute == null) {
            throw new InvalidResourceException("Sub-attribute " + externalName + " is not defined for attribute " + this.schema + ':' + this.name);
        }
        return subAttribute;
    }

    public Collection<Entry<String>> getCanonicalValues() {
        return this.canonicalValues;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public String toString() {
        return "AttributeDescriptor{schema='" + this.getSchema() + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", multiValued=" + this.isMultiValued() + ", dataType=" + (Object)((Object)this.getDataType()) + ", isRequired=" + this.isRequired() + ", isReadOnly=" + this.isReadOnly() + ", isCaseExact=" + this.isCaseExact() + '}';
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += StaticUtils.toLowerCase(this.schema).hashCode();
        return hashCode += StaticUtils.toLowerCase(this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeDescriptor)) {
            return false;
        }
        AttributeDescriptor that = (AttributeDescriptor)obj;
        if (this.schema == null && that.schema == null) {
            return this.name.equalsIgnoreCase(that.name);
        }
        return this.schema != null && that.schema != null && this.schema.equalsIgnoreCase(that.schema) && this.name.equalsIgnoreCase(that.name);
    }

    public static AttributeDescriptor createSubAttribute(String name, DataType dataType, String description, String schema, boolean readOnly, boolean required, boolean caseExact, String ... canonicalValues) {
        ArrayList<Entry<String>> values;
        if (canonicalValues != null && canonicalValues.length > 0) {
            values = new ArrayList<Entry<String>>(canonicalValues.length);
            for (String canonicalValue : canonicalValues) {
                values.add(new Entry<String>(canonicalValue, null, false));
            }
        } else {
            values = null;
        }
        return new AttributeDescriptor(name, dataType, false, null, description, schema, readOnly, required, caseExact, values, null);
    }

    public static AttributeDescriptor createAttribute(String name, DataType dataType, String description, String schema, boolean readOnly, boolean required, boolean caseExact, AttributeDescriptor ... subAttributes) {
        if (subAttributes != null) {
            for (AttributeDescriptor subAttribute : subAttributes) {
                if (subAttribute.getDataType() != DataType.COMPLEX) continue;
                throw new IllegalArgumentException("Complex sub-attributes are not allowed");
            }
        }
        return AttributeDescriptor.newAttribute(name, null, dataType, description, schema, false, readOnly, required, caseExact, subAttributes);
    }

    public static AttributeDescriptor createMultiValuedAttribute(String name, String multiValuedChildName, String description, String schema, boolean readOnly, boolean required, boolean caseExact, AttributeDescriptor ... subAttributes) {
        if (subAttributes != null) {
            for (AttributeDescriptor subAttribute : subAttributes) {
                if (subAttribute.getDataType() != DataType.COMPLEX) continue;
                throw new IllegalArgumentException("Complex sub-attributes are not allowed");
            }
        }
        return AttributeDescriptor.newAttribute(name, multiValuedChildName, DataType.COMPLEX, description, schema, true, readOnly, required, caseExact, subAttributes);
    }

    static AttributeDescriptor newAttribute(String name, String multiValuedChildName, DataType dataType, String description, String schema, boolean multiValued, boolean readOnly, boolean required, boolean caseExact, AttributeDescriptor ... subAttributes) {
        List<AttributeDescriptor> subAttrs = null;
        if (subAttributes != null) {
            subAttrs = Arrays.asList(subAttributes);
        }
        return new AttributeDescriptor(name, dataType, multiValued, multiValuedChildName, description, schema, readOnly, required, caseExact, null, subAttrs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AttributeDescriptorResolver
    extends AttributeValueResolver<AttributeDescriptor> {
        private final boolean allowNesting;

        AttributeDescriptorResolver(boolean allowNesting) {
            this.allowNesting = allowNesting;
        }

        @Override
        public AttributeDescriptor toInstance(SCIMAttributeValue value) {
            String schemaValue = value.getSubAttributeValue("schema", AttributeValueResolver.STRING_RESOLVER);
            boolean multiValued = value.getSubAttributeValue("multiValued", AttributeValueResolver.BOOLEAN_RESOLVER);
            String multiValuedChildName = null;
            if (multiValued) {
                multiValuedChildName = value.getSubAttributeValue("multiValuedAttributeChildName", AttributeValueResolver.STRING_RESOLVER);
            }
            return new AttributeDescriptor(value.getSubAttributeValue("name", AttributeValueResolver.STRING_RESOLVER), DataType.parse(value.getSubAttributeValue("type", AttributeValueResolver.STRING_RESOLVER)), multiValued, multiValuedChildName, value.getSubAttributeValue("description", AttributeValueResolver.STRING_RESOLVER), schemaValue, value.getSubAttributeValue("readOnly", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValue("required", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValue("caseExact", AttributeValueResolver.BOOLEAN_RESOLVER), null, value.getSubAttributeValues(this.allowNesting ? "attributes" : "subAttributes", this.allowNesting ? this : new SubAttributeDescriptorResolver(schemaValue)));
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, AttributeDescriptor value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> attributes = new ArrayList<SCIMAttribute>(10);
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("name"), SCIMAttributeValue.createStringValue(value.getName())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.getDataType().toString())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("multiValued"), SCIMAttributeValue.createBooleanValue(value.isMultiValued())));
            if (value.isMultiValued()) {
                attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("multiValuedAttributeChildName"), SCIMAttributeValue.createStringValue(value.getMultiValuedChildName())));
            }
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("description"), SCIMAttributeValue.createStringValue(value.getDescription())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("schema"), SCIMAttributeValue.createStringValue(value.getSchema())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("readOnly"), SCIMAttributeValue.createBooleanValue(value.isReadOnly())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("required"), SCIMAttributeValue.createBooleanValue(value.isRequired())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("caseExact"), SCIMAttributeValue.createBooleanValue(value.isCaseExact())));
            if (value.subAttributes != null) {
                AttributeDescriptor subAttributesDescriptor = this.allowNesting ? attributeDescriptor : attributeDescriptor.getSubAttribute("subAttributes");
                SCIMAttributeValue[] subAttributeValues = new SCIMAttributeValue[value.subAttributes.size()];
                int i = 0;
                for (AttributeDescriptor subAttribute : value.subAttributes.values()) {
                    subAttributeValues[i++] = (this.allowNesting ? this : new SubAttributeDescriptorResolver(value.getSchema())).fromInstance(subAttributesDescriptor, subAttribute);
                }
                attributes.add(SCIMAttribute.create(subAttributesDescriptor, subAttributeValues));
            }
            return SCIMAttributeValue.createComplexValue(attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubAttributeDescriptorResolver
    extends AttributeValueResolver<AttributeDescriptor> {
        private final String schema;

        SubAttributeDescriptorResolver(String schema) {
            this.schema = schema;
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, AttributeDescriptor value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> attributes = new ArrayList<SCIMAttribute>(9);
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("name"), SCIMAttributeValue.createStringValue(value.getName())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.getDataType().toString())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("multiValued"), SCIMAttributeValue.createBooleanValue(value.isMultiValued())));
            if (value.isMultiValued()) {
                attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("multiValuedAttributeChildName"), SCIMAttributeValue.createStringValue(value.getMultiValuedChildName())));
            }
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("description"), SCIMAttributeValue.createStringValue(value.getDescription())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("readOnly"), SCIMAttributeValue.createBooleanValue(value.isReadOnly())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("required"), SCIMAttributeValue.createBooleanValue(value.isRequired())));
            attributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("caseExact"), SCIMAttributeValue.createBooleanValue(value.isCaseExact())));
            if (value.getCanonicalValues() != null) {
                AttributeDescriptor canonicalValuesAttributeDescriptor = attributeDescriptor.getSubAttribute("canonicalValues");
                SCIMAttributeValue[] canonicalValues = new SCIMAttributeValue[value.getCanonicalValues().size()];
                int i = 0;
                for (Entry<String> canonicalValue : value.getCanonicalValues()) {
                    canonicalValues[i++] = Entry.STRINGS_RESOLVER.fromInstance(canonicalValuesAttributeDescriptor, canonicalValue);
                }
                attributes.add(SCIMAttribute.create(canonicalValuesAttributeDescriptor, canonicalValues));
            }
            return SCIMAttributeValue.createComplexValue(attributes);
        }

        @Override
        public AttributeDescriptor toInstance(SCIMAttributeValue value) {
            DataType dataType = DataType.parse(value.getSubAttributeValue("type", AttributeValueResolver.STRING_RESOLVER));
            return new AttributeDescriptor(value.getSubAttributeValue("name", AttributeValueResolver.STRING_RESOLVER), dataType, value.getSubAttributeValue("multiValued", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValue("multiValuedAttributeChildName", AttributeValueResolver.STRING_RESOLVER), value.getSubAttributeValue("description", AttributeValueResolver.STRING_RESOLVER), this.schema, value.getSubAttributeValue("readOnly", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValue("required", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValue("caseExact", AttributeValueResolver.BOOLEAN_RESOLVER), value.getSubAttributeValues("canonicalValues", Entry.STRINGS_RESOLVER), Arrays.asList(AttributeDescriptor.createSubAttribute("value", dataType, "The attribute's significant value", "urn:scim:schemas:core:1.0", false, true, false, new String[0])));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        STRING,
        BOOLEAN,
        DATETIME,
        DECIMAL,
        INTEGER,
        BINARY,
        COMPLEX;


        public static DataType parse(String type) {
            try {
                return DataType.valueOf(type.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

