/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.schema;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptor
extends BaseResource {
    public static final ResourceFactory<ResourceDescriptor> RESOURCE_DESCRIPTOR_FACTORY = new ResourceFactory<ResourceDescriptor>(){

        @Override
        public ResourceDescriptor createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new ResourceDescriptor(resourceDescriptor, scimObject);
        }
    };
    private volatile Map<String, Map<String, AttributeDescriptor>> attributesCache;
    private boolean strictMode = false;

    ResourceDescriptor(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
        super(resourceDescriptor, scimObject);
    }

    private ResourceDescriptor(ResourceDescriptor resourceDescriptor) {
        super(resourceDescriptor);
    }

    public AttributeDescriptor getAttribute(String schema, String name) throws InvalidResourceException {
        Map<String, Map<String, AttributeDescriptor>> attrCache = this.getAttributesCache();
        AttributeDescriptor attributeDescriptor = null;
        Map<String, AttributeDescriptor> map = attrCache.get(StaticUtils.toLowerCase(schema));
        if (map != null) {
            attributeDescriptor = map.get(StaticUtils.toLowerCase(name));
        }
        if (attributeDescriptor == null) {
            if (this.strictMode || "urn:scim:schemas:core:1.0".equalsIgnoreCase(schema)) {
                throw new InvalidResourceException("Attribute " + schema + ':' + name + " is not defined for resource " + this.getName());
            }
            attributeDescriptor = AttributeDescriptor.createMultiValuedAttribute(name, "value", null, schema, false, false, false, CoreSchema.createMultiValuedValueDescriptor(schema, AttributeDescriptor.DataType.STRING));
        }
        return attributeDescriptor;
    }

    public AttributeDescriptor findAttribute(String schema, String name) {
        Map<String, Map<String, AttributeDescriptor>> attrCache = this.getAttributesCache();
        Map<String, AttributeDescriptor> map = attrCache.get(StaticUtils.toLowerCase(schema));
        return map == null ? null : map.get(StaticUtils.toLowerCase(name));
    }

    public Collection<AttributeDescriptor> getAttributes(String schema) {
        Map<String, Map<String, AttributeDescriptor>> attrCache = this.getAttributesCache();
        Map<String, AttributeDescriptor> map = attrCache.get(StaticUtils.toLowerCase(schema));
        if (map != null) {
            return map.values();
        }
        return null;
    }

    public Set<String> getAttributeSchemas() {
        return this.getAttributesCache().keySet();
    }

    public String findAttributeSchema(String name, String ... preferredSchemas) {
        List<Object> preferredSchemaList;
        Map<String, Map<String, AttributeDescriptor>> attrCache = this.getAttributesCache();
        HashSet<String> matchingSchemas = new HashSet<String>();
        for (String schema : this.getAttributeSchemas()) {
            Map<String, AttributeDescriptor> map = attrCache.get(StaticUtils.toLowerCase(schema));
            if (map == null || !map.keySet().contains(name)) continue;
            matchingSchemas.add(schema);
        }
        if (matchingSchemas.isEmpty()) {
            return null;
        }
        if (preferredSchemas == null || preferredSchemas.length < 1) {
            preferredSchemaList = new ArrayList<String>(2);
            preferredSchemaList.add(this.getSchema());
            preferredSchemaList.add("urn:scim:schemas:core:1.0");
        } else {
            preferredSchemaList = Arrays.asList(preferredSchemas);
        }
        for (String string : preferredSchemaList) {
            if (!matchingSchemas.contains(string)) continue;
            return string;
        }
        return (String)matchingSchemas.iterator().next();
    }

    public String getName() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "name", AttributeValueResolver.STRING_RESOLVER);
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    private ResourceDescriptor setName(String name) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", AttributeValueResolver.STRING_RESOLVER, name);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Collection<AttributeDescriptor> getAttributes() {
        Collection<AttributeDescriptor> attributes = this.getAttributeValues("urn:scim:schemas:core:1.0", "attributes", AttributeDescriptor.ATTRIBUTE_DESCRIPTOR_RESOLVER);
        return CoreSchema.addCommonAttributes(attributes);
    }

    private ResourceDescriptor setAttributes(Collection<AttributeDescriptor> attributes) {
        try {
            this.setAttributeValues("urn:scim:schemas:core:1.0", "attributes", AttributeDescriptor.ATTRIBUTE_DESCRIPTOR_RESOLVER, attributes);
            this.attributesCache = null;
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getSchema() {
        return StaticUtils.toLowerCase(this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "schema", AttributeValueResolver.STRING_RESOLVER));
    }

    private ResourceDescriptor setSchema(String schema) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "schema", AttributeValueResolver.STRING_RESOLVER, schema);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getDescription() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "description", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setDescription(String description) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "description", AttributeValueResolver.STRING_RESOLVER, description);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getEndpoint() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "endpoint", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setEndpoint(String endpoint) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "endpoint", AttributeValueResolver.STRING_RESOLVER, endpoint);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, AttributeDescriptor>> getAttributesCache() {
        Map<String, Map<String, AttributeDescriptor>> attrCache = this.attributesCache;
        if (attrCache == null) {
            ResourceDescriptor resourceDescriptor = this;
            synchronized (resourceDescriptor) {
                attrCache = this.attributesCache;
                if (attrCache == null) {
                    attrCache = new HashMap<String, Map<String, AttributeDescriptor>>();
                    for (AttributeDescriptor attributeDescriptor : this.getAttributes()) {
                        String lowerCaseSchema = StaticUtils.toLowerCase(attributeDescriptor.getSchema());
                        Map<String, AttributeDescriptor> map = attrCache.get(lowerCaseSchema);
                        if (map == null) {
                            map = new HashMap<String, AttributeDescriptor>();
                            attrCache.put(lowerCaseSchema, map);
                        }
                        map.put(StaticUtils.toLowerCase(attributeDescriptor.getName()), attributeDescriptor);
                    }
                    this.attributesCache = attrCache;
                }
            }
        }
        return attrCache;
    }

    @Override
    public int hashCode() {
        int hashCode = 31;
        hashCode += hashCode * StaticUtils.toLowerCase(this.getSchema()).hashCode();
        hashCode += hashCode * StaticUtils.toLowerCase(this.getName()).hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceDescriptor)) {
            return false;
        }
        ResourceDescriptor that = (ResourceDescriptor)obj;
        String thisSchema = this.getSchema();
        String thisName = this.getName();
        String thatSchema = that.getSchema();
        String thatName = that.getName();
        if (thisSchema == null && thatSchema == null) {
            return thisName.equalsIgnoreCase(thatName);
        }
        return thisSchema != null && thatSchema != null && thisSchema.equalsIgnoreCase(thatSchema) && thisName.equalsIgnoreCase(thatName);
    }

    @Override
    public String toString() {
        return "ResourceDescriptor{name='" + this.getName() + '\'' + ", description='" + this.getDescription() + ", schema='" + this.getSchema() + '\'' + ", endpoint='" + this.getEndpoint() + '\'' + ", attributes=" + this.getAttributes() + '}';
    }

    public static ResourceDescriptor create(String name, String description, String schema, String endpoint, AttributeDescriptor ... attributes) {
        ResourceDescriptor resourceDescriptor = new ResourceDescriptor(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR);
        resourceDescriptor.setName(name);
        resourceDescriptor.setDescription(description);
        resourceDescriptor.setSchema(schema);
        resourceDescriptor.setEndpoint(endpoint);
        resourceDescriptor.setAttributes(Arrays.asList(attributes));
        return resourceDescriptor;
    }
}

