/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.sdk.Status;

public class BulkOperation {
    private final Method method;
    private final String bulkId;
    private final String version;
    private final String path;
    private final String location;
    private final BaseResource data;
    private final Status status;

    public BulkOperation(Method method, String bulkId, String version, String path, String location, BaseResource data, Status status) {
        this.method = method;
        this.bulkId = bulkId;
        this.version = version;
        this.path = path;
        this.location = location;
        this.data = data;
        this.status = status;
    }

    public static BulkOperation createRequest(Method method, String bulkId, String version, String path, BaseResource data) {
        return new BulkOperation(method, bulkId, version, path, null, data, null);
    }

    public static BulkOperation createResponse(Method method, String bulkId, String version, String location, Status status) {
        return new BulkOperation(method, bulkId, version, null, location, null, status);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getBulkId() {
        return this.bulkId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public String getLocation() {
        return this.location;
    }

    public BaseResource getData() {
        return this.data;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkOperation");
        sb.append("{method='").append((Object)this.method).append('\'');
        sb.append(", bulkId='").append(this.bulkId).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", location='").append(this.location).append('\'');
        sb.append(", data=").append(this.data);
        sb.append(", status=").append(this.status);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

