/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.sdk.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DebugType {
    EXCEPTION("exception"),
    CODING_ERROR("coding-error"),
    OTHER("other");

    private final String name;

    private DebugType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DebugType forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("exception")) {
            return EXCEPTION;
        }
        if (lowerName.equals("coding-error")) {
            return CODING_ERROR;
        }
        if (lowerName.equals("other")) {
            return OTHER;
        }
        return null;
    }

    public static String getTypeNameList() {
        StringBuilder buffer = new StringBuilder();
        DebugType[] types = DebugType.values();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(types[i].getName());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.name;
    }
}

