/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Diff<R extends BaseResource> {
    private final List<SCIMAttribute> attributesToUpdate;
    private final List<String> attributesToDelete;
    private final ResourceDescriptor resourceDescriptor;

    Diff(ResourceDescriptor resourceDescriptor, List<String> attributesToDelete, List<SCIMAttribute> attributesToUpdate) {
        this.resourceDescriptor = resourceDescriptor;
        this.attributesToDelete = attributesToDelete;
        this.attributesToUpdate = attributesToUpdate;
    }

    public List<String> getAttributesToDelete() {
        return this.attributesToDelete;
    }

    public List<SCIMAttribute> getAttributesToUpdate() {
        return this.attributesToUpdate;
    }

    public R apply(R sourceResource, ResourceFactory<R> resourceFactory) {
        SCIMObject scimObject = new SCIMObject(((BaseResource)sourceResource).getScimObject());
        if (this.attributesToDelete != null) {
            for (String attrPath : this.attributesToDelete) {
                SCIMAttributeValue[] path = AttributePath.parse(attrPath);
                String schema = path.getAttributeSchema();
                String attrName = path.getAttributeName();
                String subAttrName = path.getSubAttributeName();
                if (subAttrName != null) {
                    attrName = attrName + "." + subAttrName;
                }
                scimObject.removeAttribute(schema, attrName);
            }
        }
        if (this.attributesToUpdate != null) {
            for (SCIMAttribute attr : this.attributesToUpdate) {
                SCIMAttributeValue value;
                if (attr.getAttributeDescriptor().isMultiValued()) {
                    SCIMAttribute currentAttribute;
                    for (SCIMAttributeValue value2 : attr.getValues()) {
                        String operation;
                        currentAttribute = scimObject.getAttribute(attr.getSchema(), attr.getName());
                        if (!value2.isComplex() || !"delete".equalsIgnoreCase(operation = value2.getSubAttributeValue("operation", AttributeValueResolver.STRING_RESOLVER))) continue;
                        ArrayList<SCIMAttribute> arrayList = new ArrayList<SCIMAttribute>();
                        Map<String, SCIMAttribute> subAttrMap = value2.getAttributes();
                        for (String subAttrName : subAttrMap.keySet()) {
                            if ("operation".equalsIgnoreCase(subAttrName)) continue;
                            arrayList.add(subAttrMap.get(subAttrName));
                        }
                        SCIMAttributeValue valueToDelete = SCIMAttributeValue.createComplexValue(arrayList);
                        if (currentAttribute == null) continue;
                        HashSet<SCIMAttributeValue> newValues = new HashSet<SCIMAttributeValue>();
                        for (SCIMAttributeValue sCIMAttributeValue : currentAttribute.getValues()) {
                            if (sCIMAttributeValue.equals(valueToDelete)) continue;
                            newValues.add(sCIMAttributeValue);
                        }
                        if (!newValues.isEmpty()) {
                            SCIMAttribute sCIMAttribute = SCIMAttribute.create(attr.getAttributeDescriptor(), newValues.toArray(new SCIMAttributeValue[newValues.size()]));
                            scimObject.setAttribute(sCIMAttribute);
                            continue;
                        }
                        scimObject.removeAttribute(attr.getSchema(), attr.getName());
                    }
                    for (SCIMAttributeValue value2 : attr.getValues()) {
                        currentAttribute = scimObject.getAttribute(attr.getSchema(), attr.getName());
                        HashSet<SCIMAttributeValue> newValues = new HashSet<SCIMAttributeValue>();
                        if (value2.isComplex()) {
                            String string = value2.getSubAttributeValue("operation", AttributeValueResolver.STRING_RESOLVER);
                            if ("delete".equalsIgnoreCase(string)) continue;
                            String type = value2.getSubAttributeValue("type", AttributeValueResolver.STRING_RESOLVER);
                            if (currentAttribute != null) {
                                SCIMAttributeValue valueToUpdate = null;
                                LinkedList<SCIMAttributeValue> finalValues = new LinkedList<SCIMAttributeValue>();
                                for (SCIMAttributeValue sCIMAttributeValue : currentAttribute.getValues()) {
                                    String currentType = sCIMAttributeValue.getSubAttributeValue("type", AttributeValueResolver.STRING_RESOLVER);
                                    if (type != null && type.equalsIgnoreCase(currentType)) {
                                        valueToUpdate = sCIMAttributeValue;
                                        continue;
                                    }
                                    if (sCIMAttributeValue.equals(value2)) continue;
                                    finalValues.add(sCIMAttributeValue);
                                }
                                if (valueToUpdate != null) {
                                    Map<String, SCIMAttribute> map = value2.getAttributes();
                                    Map<String, SCIMAttribute> existingSubAttrMap = valueToUpdate.getAttributes();
                                    HashMap<String, SCIMAttribute> finalSubAttrs = new HashMap<String, SCIMAttribute>();
                                    for (String subAttrName : existingSubAttrMap.keySet()) {
                                        if (map.containsKey(subAttrName)) {
                                            finalSubAttrs.put(subAttrName, map.get(subAttrName));
                                            continue;
                                        }
                                        finalSubAttrs.put(subAttrName, existingSubAttrMap.get(subAttrName));
                                    }
                                    for (String subAttrName : map.keySet()) {
                                        if (finalSubAttrs.containsKey(subAttrName)) continue;
                                        finalSubAttrs.put(subAttrName, map.get(subAttrName));
                                    }
                                    SCIMAttributeValue sCIMAttributeValue = SCIMAttributeValue.createComplexValue(finalSubAttrs.values());
                                    finalValues.add(sCIMAttributeValue);
                                } else {
                                    SCIMAttributeValue sCIMAttributeValue = SCIMAttributeValue.createComplexValue(value2.getAttributes().values());
                                    finalValues.add(sCIMAttributeValue);
                                }
                                attr = SCIMAttribute.create(attr.getAttributeDescriptor(), finalValues.toArray(new SCIMAttributeValue[finalValues.size()]));
                            }
                            scimObject.setAttribute(attr);
                            continue;
                        }
                        if (currentAttribute != null) {
                            for (SCIMAttributeValue currentValue : currentAttribute.getValues()) {
                                newValues.add(currentValue);
                            }
                        }
                        newValues.add(value2);
                        SCIMAttribute sCIMAttribute = SCIMAttribute.create(attr.getAttributeDescriptor(), newValues.toArray(new SCIMAttributeValue[newValues.size()]));
                        scimObject.setAttribute(sCIMAttribute);
                    }
                    continue;
                }
                if (scimObject.hasAttribute(attr.getSchema(), attr.getName()) && (value = attr.getValue()).isComplex()) {
                    SCIMAttribute existingAttr = scimObject.getAttribute(attr.getSchema(), attr.getName());
                    SCIMAttributeValue existingValue = existingAttr.getValue();
                    Map<String, SCIMAttribute> subAttrMap = value.getAttributes();
                    Map<String, SCIMAttribute> existingSubAttrMap = existingValue.getAttributes();
                    HashMap<String, SCIMAttribute> finalSubAttrs = new HashMap<String, SCIMAttribute>();
                    for (String subAttrName : existingSubAttrMap.keySet()) {
                        if (subAttrMap.containsKey(subAttrName)) {
                            finalSubAttrs.put(subAttrName, subAttrMap.get(subAttrName));
                            continue;
                        }
                        finalSubAttrs.put(subAttrName, existingSubAttrMap.get(subAttrName));
                    }
                    for (String subAttrName : subAttrMap.keySet()) {
                        if (finalSubAttrs.containsKey(subAttrName)) continue;
                        finalSubAttrs.put(subAttrName, subAttrMap.get(subAttrName));
                    }
                    SCIMAttributeValue sCIMAttributeValue = SCIMAttributeValue.createComplexValue(finalSubAttrs.values());
                    attr = SCIMAttribute.create(attr.getAttributeDescriptor(), sCIMAttributeValue);
                }
                scimObject.setAttribute(attr);
            }
        }
        return resourceFactory.createResource(this.resourceDescriptor, scimObject);
    }

    public R toPartialResource(ResourceFactory<R> resourceFactory, boolean includeReadOnlyAttributes) throws InvalidResourceException {
        SCIMObject scimObject = new SCIMObject();
        if (this.attributesToDelete != null && !this.attributesToDelete.isEmpty()) {
            SCIMAttributeValue[] values = new SCIMAttributeValue[this.attributesToDelete.size()];
            for (int i = 0; i < this.attributesToDelete.size(); ++i) {
                values[i] = SCIMAttributeValue.createStringValue(this.attributesToDelete.get(i));
            }
            AttributeDescriptor subDescriptor = CoreSchema.META_DESCRIPTOR.getSubAttribute("attributes");
            SCIMAttribute attributes = SCIMAttribute.create(subDescriptor, values);
            SCIMAttribute meta = SCIMAttribute.create(CoreSchema.META_DESCRIPTOR, SCIMAttributeValue.createComplexValue(attributes));
            scimObject.setAttribute(meta);
        }
        if (this.attributesToUpdate != null) {
            for (SCIMAttribute attr : this.attributesToUpdate) {
                if (attr.getAttributeDescriptor().isReadOnly() && !includeReadOnlyAttributes) continue;
                scimObject.setAttribute(attr);
            }
        }
        return resourceFactory.createResource(this.resourceDescriptor, scimObject);
    }

    public static <R extends BaseResource> Diff<R> fromPartialResource(R partialResource, boolean includeReadOnlyAttributes) {
        SCIMAttribute attributesAttr;
        SCIMObject scimObject = new SCIMObject(partialResource.getScimObject());
        HashSet<String> attributesToDelete = new HashSet<String>();
        ArrayList<SCIMAttribute> attributesToUpdate = new ArrayList<SCIMAttribute>(10);
        SCIMAttribute metaAttr = scimObject.getAttribute("urn:scim:schemas:core:1.0", "meta");
        if (metaAttr != null && (attributesAttr = metaAttr.getValue().getAttribute("attributes")) != null) {
            for (SCIMAttributeValue attrPath : attributesAttr.getValues()) {
                attributesToDelete.add(attrPath.getStringValue());
            }
        }
        if (!includeReadOnlyAttributes) {
            scimObject.removeAttribute("urn:scim:schemas:core:1.0", "meta");
        }
        for (String schema : scimObject.getSchemas()) {
            for (SCIMAttribute attr : scimObject.getAttributes(schema)) {
                if (attr.getAttributeDescriptor().isReadOnly() && !includeReadOnlyAttributes) continue;
                attributesToUpdate.add(attr);
            }
        }
        return new Diff<R>(partialResource.getResourceDescriptor(), Collections.unmodifiableList(new ArrayList(attributesToDelete)), Collections.unmodifiableList(attributesToUpdate));
    }

    /*
     * WARNING - void declaration
     */
    public static <R extends BaseResource> Diff<R> generate(R source, R target, String ... attributes) {
        Map<String, SCIMAttribute> subAttrs;
        SCIMObject sourceObject = source.getScimObject();
        SCIMObject targetObject = target.getScimObject();
        HashMap<String, HashMap<String, HashSet<String>>> compareAttrs = null;
        if (attributes != null && attributes.length > 0) {
            compareAttrs = new HashMap<String, HashMap<String, HashSet<String>>>();
            for (String string : attributes) {
                AttributePath path = AttributePath.parse(string);
                String schema = StaticUtils.toLowerCase(path.getAttributeSchema());
                String attrName = StaticUtils.toLowerCase(path.getAttributeName());
                String subAttrName = path.getSubAttributeName() == null ? null : StaticUtils.toLowerCase(path.getSubAttributeName());
                HashMap<String, HashSet<String>> schemaAttrs = compareAttrs.get(schema);
                if (schemaAttrs == null) {
                    schemaAttrs = new HashMap();
                    compareAttrs.put(schema, schemaAttrs);
                }
                if ((subAttrs = schemaAttrs.get(attrName)) == null) {
                    subAttrs = new HashSet();
                    schemaAttrs.put(attrName, (HashSet<String>)((Object)subAttrs));
                }
                if (subAttrName == null) continue;
                ((HashSet)((Object)subAttrs)).add((String)subAttrName);
            }
        }
        SCIMObject sourceOnlyAttrs = new SCIMObject();
        SCIMObject targetOnlyAttrs = new SCIMObject();
        SCIMObject commonAttrs = new SCIMObject();
        for (String schema : sourceObject.getSchemas()) {
            for (SCIMAttribute attribute : sourceObject.getAttributes(schema)) {
                if (!Diff.shouldProcess(compareAttrs, attribute, null)) continue;
                sourceOnlyAttrs.setAttribute(attribute);
                commonAttrs.setAttribute(attribute);
            }
        }
        for (String schema : targetObject.getSchemas()) {
            for (SCIMAttribute attribute : targetObject.getAttributes(schema)) {
                if (!Diff.shouldProcess(compareAttrs, attribute, null) || sourceOnlyAttrs.removeAttribute(attribute.getSchema(), attribute.getName())) continue;
                targetOnlyAttrs.setAttribute(attribute);
            }
        }
        for (String schema : sourceOnlyAttrs.getSchemas()) {
            for (SCIMAttribute attribute : sourceOnlyAttrs.getAttributes(schema)) {
                commonAttrs.removeAttribute(attribute.getSchema(), attribute.getName());
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SCIMAttribute> attributesToUpdate = new ArrayList<SCIMAttribute>(10);
        for (String schema : sourceOnlyAttrs.getSchemas()) {
            for (SCIMAttribute sourceAttribute : sourceOnlyAttrs.getAttributes(schema)) {
                Diff.deleteAttribute(compareAttrs, hashSet, sourceAttribute);
            }
        }
        for (String schema : targetOnlyAttrs.getSchemas()) {
            for (SCIMAttribute targetAttribute : targetOnlyAttrs.getAttributes(schema)) {
                if (targetAttribute.getAttributeDescriptor().isMultiValued()) {
                    ArrayList<SCIMAttributeValue> targetValues = new ArrayList<SCIMAttributeValue>(targetAttribute.getValues().length);
                    for (SCIMAttributeValue targetValue : targetAttribute.getValues()) {
                        Map<String, SCIMAttribute> map = Diff.filterSubAttributes(compareAttrs, targetAttribute, targetValue);
                        if (map.isEmpty()) continue;
                        targetValues.add(SCIMAttributeValue.createComplexValue(map.values()));
                    }
                    if (targetValues.isEmpty()) continue;
                    attributesToUpdate.add(SCIMAttribute.create(targetAttribute.getAttributeDescriptor(), targetValues.toArray(new SCIMAttributeValue[targetValues.size()])));
                    continue;
                }
                if (targetAttribute.getValue().isComplex()) {
                    subAttrs = Diff.filterSubAttributes(compareAttrs, targetAttribute, targetAttribute.getValue());
                    if (subAttrs.isEmpty()) continue;
                    attributesToUpdate.add(SCIMAttribute.create(targetAttribute.getAttributeDescriptor(), SCIMAttributeValue.createComplexValue(subAttrs.values())));
                    continue;
                }
                attributesToUpdate.add(targetAttribute);
            }
        }
        for (String schema : commonAttrs.getSchemas()) {
            for (SCIMAttribute sourceAttribute : commonAttrs.getAttributes(schema)) {
                SCIMAttribute targetAttribute;
                if (sourceAttribute.equals(targetAttribute = targetObject.getAttribute(sourceAttribute.getSchema(), sourceAttribute.getName()))) continue;
                if (sourceAttribute.getAttributeDescriptor().isMultiValued()) {
                    void var20_32;
                    Set<Object> sourceValues = new LinkedHashSet(sourceAttribute.getValues().length);
                    LinkedHashSet<SCIMAttributeValue> targetValues = new LinkedHashSet<SCIMAttributeValue>(targetAttribute.getValues().length);
                    Collections.addAll(sourceValues, sourceAttribute.getValues());
                    SCIMAttributeValue[] sCIMAttributeValueArray = targetAttribute.getValues();
                    int targetValue = sCIMAttributeValueArray.length;
                    boolean bl = false;
                    while (var20_32 < targetValue) {
                        SCIMAttributeValue v = sCIMAttributeValueArray[var20_32];
                        if (!sourceValues.remove(v)) {
                            targetValues.add(v);
                        }
                        ++var20_32;
                    }
                    if (sourceValues.size() == sourceAttribute.getValues().length) {
                        Diff.deleteAttribute(compareAttrs, hashSet, sourceAttribute);
                        sourceValues = Collections.emptySet();
                    }
                    ArrayList patchValues = new ArrayList(sourceValues.size() + targetValues.size());
                    for (SCIMAttributeValue sCIMAttributeValue : sourceValues) {
                        SCIMAttribute operationAttr;
                        Map<String, SCIMAttribute> subAttrs3 = Diff.filterSubAttributes(compareAttrs, sourceAttribute, sCIMAttributeValue);
                        if (subAttrs3.isEmpty()) continue;
                        try {
                            operationAttr = SCIMAttribute.create(sourceAttribute.getAttributeDescriptor().getSubAttribute("operation"), SCIMAttributeValue.createStringValue("delete"));
                        }
                        catch (InvalidResourceException e) {
                            throw new IllegalStateException(e);
                        }
                        subAttrs3.put(StaticUtils.toLowerCase(operationAttr.getName()), operationAttr);
                        patchValues.add(SCIMAttributeValue.createComplexValue(subAttrs3.values()));
                    }
                    for (SCIMAttributeValue sCIMAttributeValue : targetValues) {
                        Map<String, SCIMAttribute> subAttrs2 = Diff.filterSubAttributes(compareAttrs, targetAttribute, sCIMAttributeValue);
                        if (subAttrs2.isEmpty()) continue;
                        patchValues.add(SCIMAttributeValue.createComplexValue(subAttrs2.values()));
                    }
                    if (patchValues.isEmpty()) continue;
                    attributesToUpdate.add(SCIMAttribute.create(sourceAttribute.getAttributeDescriptor(), patchValues.toArray(new SCIMAttributeValue[patchValues.size()])));
                    continue;
                }
                if (sourceAttribute.getValue().isComplex()) {
                    SCIMAttributeValue sourceAttributeValue = sourceAttribute.getValue();
                    SCIMAttributeValue targetAttributeValue = targetAttribute.getValue();
                    for (Map.Entry<String, SCIMAttribute> e : Diff.filterSubAttributes(compareAttrs, sourceAttribute, sourceAttributeValue).entrySet()) {
                        if (targetAttributeValue.hasAttribute(e.getKey())) continue;
                        AttributePath attributePath = new AttributePath(sourceAttribute.getSchema(), sourceAttribute.getName(), e.getValue().getName());
                        hashSet.add(attributePath.toString());
                    }
                    Map<String, SCIMAttribute> targetSubAttrs = Diff.filterSubAttributes(compareAttrs, targetAttribute, targetAttributeValue);
                    Iterator<Map.Entry<String, SCIMAttribute>> targetIterator = targetSubAttrs.entrySet().iterator();
                    while (targetIterator.hasNext()) {
                        Map.Entry<String, SCIMAttribute> entry = targetIterator.next();
                        SCIMAttribute sourceSubAttr = sourceAttributeValue.getAttribute(entry.getKey());
                        if (sourceSubAttr == null || !sourceSubAttr.equals(entry.getValue())) continue;
                        targetIterator.remove();
                    }
                    if (targetSubAttrs.isEmpty()) continue;
                    attributesToUpdate.add(SCIMAttribute.create(targetAttribute.getAttributeDescriptor(), SCIMAttributeValue.createComplexValue(targetSubAttrs.values())));
                    continue;
                }
                attributesToUpdate.add(targetAttribute);
            }
        }
        return new Diff<R>(source.getResourceDescriptor(), Collections.unmodifiableList(new ArrayList<String>(hashSet)), Collections.unmodifiableList(attributesToUpdate));
    }

    private static boolean shouldProcess(HashMap<String, HashMap<String, HashSet<String>>> compareAttrs, SCIMAttribute attribute, SCIMAttribute subAttribute) {
        if (compareAttrs == null) {
            return true;
        }
        HashMap<String, HashSet<String>> schemaAttrs = compareAttrs.get(StaticUtils.toLowerCase(attribute.getSchema()));
        if (schemaAttrs == null) {
            return false;
        }
        HashSet<String> subAttrs = schemaAttrs.get(StaticUtils.toLowerCase(attribute.getName()));
        return subAttrs != null && (subAttribute == null || subAttrs.isEmpty() || subAttrs.contains(StaticUtils.toLowerCase(subAttribute.getName())));
    }

    private static Map<String, SCIMAttribute> filterSubAttributes(HashMap<String, HashMap<String, HashSet<String>>> compareAttrs, SCIMAttribute attribute, SCIMAttributeValue value) {
        LinkedHashMap<String, SCIMAttribute> filteredSubAttributes = new LinkedHashMap<String, SCIMAttribute>(value.getAttributes());
        Iterator subAttrsIterator = filteredSubAttributes.entrySet().iterator();
        while (subAttrsIterator.hasNext()) {
            Map.Entry e = subAttrsIterator.next();
            if (Diff.shouldProcess(compareAttrs, attribute, (SCIMAttribute)e.getValue())) continue;
            subAttrsIterator.remove();
        }
        return filteredSubAttributes;
    }

    private static void deleteAttribute(HashMap<String, HashMap<String, HashSet<String>>> compareAttrs, Set<String> attributesToDelete, SCIMAttribute attribute) {
        if (attribute.getAttributeDescriptor().isMultiValued()) {
            HashSet<String> subAttributes = new HashSet<String>();
            for (SCIMAttributeValue sourceValue : attribute.getValues()) {
                if (sourceValue.isComplex()) {
                    for (Map.Entry<String, SCIMAttribute> e : Diff.filterSubAttributes(compareAttrs, attribute, sourceValue).entrySet()) {
                        if (e.getKey().equals("type") || e.getKey().equals("primary") || e.getKey().equals("operation") || e.getKey().equals("display")) continue;
                        AttributePath path = new AttributePath(attribute.getSchema(), attribute.getName(), e.getKey());
                        subAttributes.add(path.toString());
                    }
                    continue;
                }
                AttributePath path = new AttributePath(attribute.getSchema(), attribute.getName(), null);
                subAttributes.clear();
                attributesToDelete.add(path.toString());
                break;
            }
            attributesToDelete.addAll(subAttributes);
        } else if (attribute.getAttributeDescriptor().getDataType() == AttributeDescriptor.DataType.COMPLEX) {
            for (Map.Entry<String, SCIMAttribute> e : Diff.filterSubAttributes(compareAttrs, attribute, attribute.getValue()).entrySet()) {
                AttributePath path = new AttributePath(attribute.getSchema(), attribute.getName(), e.getKey());
                attributesToDelete.add(path.toString());
            }
        } else {
            AttributePath path = new AttributePath(attribute.getSchema(), attribute.getName(), null);
            attributesToDelete.add(path.toString());
        }
    }
}

