/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilter;
import com.unboundid.scim.sdk.SCIMFilterType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.json.JSONObject;

public class FilterParser {
    private final String filterString;
    private final String defaultSchema;
    private int endPos;
    private int currentPos;
    private int markPos;

    public FilterParser(String filterString, String defaultSchema) {
        this.filterString = filterString;
        this.endPos = filterString.length();
        this.currentPos = 0;
        this.markPos = 0;
        this.defaultSchema = defaultSchema;
    }

    public SCIMFilter parse() throws SCIMException {
        try {
            return this.readFilter();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw SCIMException.createException(400, MessageFormat.format("Invalid filter ''{0}'': {1}", this.filterString, e.getMessage()));
        }
    }

    private SCIMFilter readFilterComponent() {
        Object filterValue;
        SCIMFilterType filterType;
        AttributePath filterAttribute;
        String word = this.readWord();
        if (word == null) {
            String msg = String.format("End of input at position %d but expected a filter expression", this.markPos);
            throw new IllegalArgumentException(msg);
        }
        try {
            filterAttribute = AttributePath.parse(word, this.defaultSchema);
        }
        catch (Exception e) {
            Debug.debugException(e);
            String msg = String.format("Expected an attribute reference at position %d: %s", this.markPos, e.getMessage());
            throw new IllegalArgumentException(msg);
        }
        String operator = this.readWord();
        if (operator == null) {
            String msg = String.format("End of input at position %d but expected an attribute operator", this.markPos);
            throw new IllegalArgumentException(msg);
        }
        if (operator.equalsIgnoreCase("eq")) {
            filterType = SCIMFilterType.EQUALITY;
        } else if (operator.equalsIgnoreCase("co")) {
            filterType = SCIMFilterType.CONTAINS;
        } else if (operator.equalsIgnoreCase("sw")) {
            filterType = SCIMFilterType.STARTS_WITH;
        } else if (operator.equalsIgnoreCase("pr")) {
            filterType = SCIMFilterType.PRESENCE;
        } else if (operator.equalsIgnoreCase("gt")) {
            filterType = SCIMFilterType.GREATER_THAN;
        } else if (operator.equalsIgnoreCase("ge")) {
            filterType = SCIMFilterType.GREATER_OR_EQUAL;
        } else if (operator.equalsIgnoreCase("lt")) {
            filterType = SCIMFilterType.LESS_THAN;
        } else if (operator.equalsIgnoreCase("le")) {
            filterType = SCIMFilterType.LESS_OR_EQUAL;
        } else {
            String msg = String.format("Unrecognized attribute operator '%s' at position %d. Expected: eq,co,sw,pr,gt,ge,lt,le", operator, this.markPos);
            throw new IllegalArgumentException(msg);
        }
        if (!filterType.equals((Object)SCIMFilterType.PRESENCE)) {
            filterValue = this.readValue();
            if (filterValue == null) {
                String msg = String.format("End of input at position %d while expecting a value for operator %s", this.markPos, operator);
                throw new IllegalArgumentException(msg);
            }
        } else {
            filterValue = null;
        }
        String filterValueString = filterValue != null ? filterValue.toString() : null;
        return new SCIMFilter(filterType, filterAttribute, filterValueString, filterValue != null && filterValue instanceof String, null);
    }

    private SCIMFilter readFilter() {
        Object msg3;
        Stack<Node> expressionStack = new Stack<Node>();
        ArrayList reversePolish = new ArrayList();
        String word = this.readWord();
        while (word != null) {
            if (word.equalsIgnoreCase("and") || word.equalsIgnoreCase("or")) {
                OperatorNode previousOperator;
                OperatorNode currentOperator = word.equalsIgnoreCase("and") ? new OperatorNode(SCIMFilterType.AND, this.markPos) : new OperatorNode(SCIMFilterType.OR, this.markPos);
                while (!expressionStack.empty() && expressionStack.peek() instanceof OperatorNode && (previousOperator = (OperatorNode)expressionStack.peek()).getPrecedence() >= currentOperator.getPrecedence()) {
                    reversePolish.add(expressionStack.pop());
                }
                expressionStack.push(currentOperator);
            } else if (word.equals("(")) {
                expressionStack.push(new LeftParenthesisNode(this.markPos));
            } else if (word.equals(")")) {
                while (!expressionStack.empty() && !(expressionStack.peek() instanceof LeftParenthesisNode)) {
                    reversePolish.add(expressionStack.pop());
                }
                if (expressionStack.empty()) {
                    String msg2 = String.format("No opening parenthesis matching closing parenthesis at position %d", this.markPos);
                    throw new IllegalArgumentException(msg2);
                }
                expressionStack.pop();
            } else {
                this.rewind();
                int pos = this.currentPos;
                SCIMFilter filterComponent = this.readFilterComponent();
                reversePolish.add(new FilterNode(filterComponent, pos));
            }
            word = this.readWord();
        }
        while (!expressionStack.empty()) {
            Node node = (Node)expressionStack.pop();
            if (node instanceof LeftParenthesisNode) {
                String msg3 = String.format("No closing parenthesis matching opening parenthesis at position %d", node.getPos());
                throw new IllegalArgumentException(msg3);
            }
            reversePolish.add(node);
        }
        Stack<FilterNode> filterStack = new Stack<FilterNode>();
        for (Node node : reversePolish) {
            if (node instanceof OperatorNode) {
                SCIMFilter filter;
                FilterNode rightOperand = (FilterNode)filterStack.pop();
                FilterNode leftOperand = (FilterNode)filterStack.pop();
                OperatorNode operatorNode = (OperatorNode)node;
                if (operatorNode.getFilterType().equals((Object)SCIMFilterType.AND)) {
                    filter = SCIMFilter.createAndFilter(Arrays.asList(leftOperand.getFilterComponent(), rightOperand.getFilterComponent()));
                    filterStack.push(new FilterNode(filter, leftOperand.getPos()));
                    continue;
                }
                filter = SCIMFilter.createOrFilter(Arrays.asList(leftOperand.getFilterComponent(), rightOperand.getFilterComponent()));
                filterStack.push(new FilterNode(filter, leftOperand.getPos()));
                continue;
            }
            filterStack.push((FilterNode)node);
        }
        if (filterStack.size() == 0) {
            msg3 = String.format("Empty filter expression", new Object[0]);
            throw new IllegalArgumentException((String)msg3);
        }
        if (filterStack.size() > 1) {
            msg3 = String.format("Unexpected characters at position %d", ((Node)expressionStack.get(1)).pos);
            throw new IllegalArgumentException((String)msg3);
        }
        return ((FilterNode)filterStack.get(0)).filterComponent;
    }

    private String readWord() {
        this.skipWhitespace();
        this.markPos = this.currentPos;
        block4: while (this.currentPos < this.endPos) {
            char c = this.filterString.charAt(this.currentPos);
            switch (c) {
                case '(': 
                case ')': {
                    if (this.currentPos != this.markPos) break block4;
                    ++this.currentPos;
                    break block4;
                }
                case ' ': {
                    break block4;
                }
                default: {
                    ++this.currentPos;
                    continue block4;
                }
            }
        }
        if (this.currentPos - this.markPos == 0) {
            return null;
        }
        String word = this.filterString.substring(this.markPos, this.currentPos);
        this.skipWhitespace();
        return word;
    }

    private void rewind() {
        this.currentPos = this.markPos;
    }

    public Object readValue() {
        this.skipWhitespace();
        this.markPos = this.currentPos;
        if (this.currentPos == this.endPos) {
            return null;
        }
        if (this.filterString.charAt(this.currentPos) == '\"') {
            ++this.currentPos;
            StringBuilder builder = new StringBuilder();
            while (this.currentPos < this.endPos) {
                char c = this.filterString.charAt(this.currentPos);
                block0 : switch (c) {
                    case '\\': {
                        ++this.currentPos;
                        if (this.endOfInput()) {
                            String msg = String.format("End of input in a string value that began at position %d", this.markPos);
                            throw new IllegalArgumentException(msg);
                        }
                        char escapeChar = this.filterString.charAt(this.currentPos);
                        ++this.currentPos;
                        switch (escapeChar) {
                            case '\"': 
                            case '\'': 
                            case '/': 
                            case '\\': {
                                builder.append(escapeChar);
                                break block0;
                            }
                            case 'b': {
                                builder.append('\b');
                                break block0;
                            }
                            case 'f': {
                                builder.append('\f');
                                break block0;
                            }
                            case 'n': {
                                builder.append('\n');
                                break block0;
                            }
                            case 'r': {
                                builder.append('\r');
                                break block0;
                            }
                            case 't': {
                                builder.append('\t');
                                break block0;
                            }
                            case 'u': {
                                if (this.currentPos + 4 > this.endPos) {
                                    String msg = String.format("End of input in a string value that began at position %d", this.markPos);
                                    throw new IllegalArgumentException(msg);
                                }
                                String hexChars = this.filterString.substring(this.currentPos, this.currentPos + 4);
                                builder.append((char)Integer.parseInt(hexChars, 16));
                                this.currentPos += 4;
                                break block0;
                            }
                        }
                        String msg = String.format("Unrecognized escape sequence '\\%c' in a string value at position %d", Character.valueOf(escapeChar), this.currentPos - 2);
                        throw new IllegalArgumentException(msg);
                    }
                    case '\"': {
                        ++this.currentPos;
                        this.skipWhitespace();
                        return builder.toString();
                    }
                    default: {
                        builder.append(c);
                        ++this.currentPos;
                    }
                }
            }
            String msg = String.format("End of input in a string value that began at position %d", this.markPos);
            throw new IllegalArgumentException(msg);
        }
        block18: while (this.currentPos < this.endPos) {
            char c = this.filterString.charAt(this.currentPos);
            switch (c) {
                case ' ': 
                case '(': 
                case ')': {
                    break block18;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    ++this.currentPos;
                    break;
                }
                default: {
                    String msg = String.format("Invalid character '%c' in a number or boolean value at position %d", Character.valueOf(c), this.currentPos);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        String s = this.filterString.substring(this.markPos, this.currentPos);
        this.skipWhitespace();
        Object value = JSONObject.stringToValue((String)s);
        if (value.equals(JSONObject.NULL) || value instanceof String) {
            String msg = String.format("Invalid filter value beginning at position %d", this.markPos);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private boolean endOfInput() {
        return this.currentPos == this.endPos;
    }

    private void skipWhitespace() {
        while (this.currentPos < this.endPos && this.filterString.charAt(this.currentPos) == ' ') {
            ++this.currentPos;
        }
    }

    class LeftParenthesisNode
    extends Node {
        public LeftParenthesisNode(int pos) {
            super(pos);
        }
    }

    class OperatorNode
    extends Node {
        private final SCIMFilterType filterType;

        public OperatorNode(SCIMFilterType filterType, int pos) {
            super(pos);
            this.filterType = filterType;
        }

        public SCIMFilterType getFilterType() {
            return this.filterType;
        }

        public int getPrecedence() {
            switch (this.filterType) {
                case AND: {
                    return 2;
                }
            }
            return 1;
        }

        public String toString() {
            return "OperatorNode{filterType=" + (Object)((Object)this.filterType) + "} " + super.toString();
        }
    }

    class FilterNode
    extends Node {
        private final SCIMFilter filterComponent;

        public FilterNode(SCIMFilter filterComponent, int pos) {
            super(pos);
            this.filterComponent = filterComponent;
        }

        public SCIMFilter getFilterComponent() {
            return this.filterComponent;
        }

        public String toString() {
            return "FilterNode{filterComponent=" + this.filterComponent + "} " + super.toString();
        }
    }

    class Node {
        private final int pos;

        public Node(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

