/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.GetResourceRequest;
import com.unboundid.scim.sdk.GetResourcesRequest;
import com.unboundid.scim.sdk.PatchResourceRequest;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.ResourceNotFoundException;
import com.unboundid.scim.sdk.ResourceReturningRequest;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.UnsupportedOperationException;
import com.unboundid.scim.wink.SCIMApplication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSchemaBackend
extends SCIMBackend {
    private final SCIMApplication application;

    public ResourceSchemaBackend(SCIMApplication application) {
        this.application = application;
    }

    @Override
    public void finalizeBackend() {
    }

    @Override
    public ResourceDescriptor getResource(GetResourceRequest request) throws SCIMException {
        ResourceDescriptor resourceDescriptor = null;
        for (ResourceDescriptor rd : this.application.getBackend().getResourceDescriptors()) {
            String id = rd.getSchema() + ':' + rd.getName();
            if (!id.equalsIgnoreCase(request.getResourceID())) continue;
            resourceDescriptor = rd;
            break;
        }
        if (resourceDescriptor == null) {
            for (ResourceDescriptor rd : this.application.getBackend().getResourceDescriptors()) {
                if (!rd.getName().equalsIgnoreCase(request.getResourceID())) continue;
                resourceDescriptor = rd;
                break;
            }
        }
        if (resourceDescriptor == null) {
            throw new ResourceNotFoundException("No Resource Schema with ID " + request.getResourceID() + " exists");
        }
        return ResourceSchemaBackend.copyAndSetIdAndMetaAttributes(resourceDescriptor, request);
    }

    @Override
    public Resources getResources(GetResourcesRequest request) throws SCIMException {
        List<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>(this.application.getBackend().getResourceDescriptors().size());
        for (ResourceDescriptor resourceDescriptor : this.application.getBackend().getResourceDescriptors()) {
            ResourceDescriptor copy = ResourceSchemaBackend.copyAndSetIdAndMetaAttributes(resourceDescriptor, request);
            if (request.getFilter() != null && !copy.getScimObject().matchesFilter(request.getFilter())) continue;
            rds.add(copy);
        }
        int fromIndex = 0;
        int total = rds.size();
        if (request.getPageParameters() != null) {
            fromIndex = request.getPageParameters().getStartIndex() - 1;
            int endIndex = Math.min(request.getPageParameters().getCount() + fromIndex, rds.size());
            rds = rds.subList(fromIndex, endIndex);
        }
        return new Resources(rds, total, fromIndex + 1);
    }

    @Override
    public BaseResource postResource(PostResourceRequest request) throws SCIMException {
        throw new UnsupportedOperationException("POST operations are not allowed on the Resource Schema");
    }

    @Override
    public void deleteResource(DeleteResourceRequest request) throws SCIMException {
        throw new UnsupportedOperationException("DELETE operations are not allowed on the Resource Schema");
    }

    @Override
    public BaseResource putResource(PutResourceRequest request) throws SCIMException {
        throw new UnsupportedOperationException("PUT operations are not allowed on the Resource Schema");
    }

    @Override
    public BaseResource patchResource(PatchResourceRequest request) throws SCIMException {
        throw new UnsupportedOperationException("PATCH operations are not allowed on the Resource Schema");
    }

    @Override
    public Collection<ResourceDescriptor> getResourceDescriptors() {
        return Collections.singleton(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR);
    }

    public static ResourceDescriptor copyAndSetIdAndMetaAttributes(ResourceDescriptor resource, ResourceReturningRequest request) {
        ResourceDescriptor copy = ResourceDescriptor.RESOURCE_DESCRIPTOR_FACTORY.createResource(resource.getResourceDescriptor(), new SCIMObject(resource.getScimObject()));
        String id = resource.getSchema() + ':' + resource.getName();
        copy.setId(id);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)request.getBaseURL());
        if (!request.getBaseURL().getPath().endsWith("v1/")) {
            uriBuilder.path("v1");
        }
        uriBuilder.path(resource.getResourceDescriptor().getEndpoint());
        uriBuilder.path(id);
        copy.setMeta(new Meta(null, null, uriBuilder.build(new Object[0]), null));
        return ResourceDescriptor.RESOURCE_DESCRIPTOR_FACTORY.createResource(resource.getResourceDescriptor(), request.getAttributes().pareObject(copy.getScimObject()));
    }
}

