/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.sdk.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticUtils {
    private StaticUtils() {
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] charArray = s.toCharArray();
        block28: for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case 'A': {
                    charArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    charArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    charArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    charArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    charArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    charArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    charArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    charArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    charArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    charArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    charArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    charArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    charArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    charArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    charArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    charArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    charArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    charArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    charArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    charArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    charArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    charArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    charArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    charArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    charArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    charArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (charArray[i] <= '\u007f') continue block28;
                    return s.toLowerCase();
                }
            }
        }
        return new String(charArray);
    }

    public static String listToString(List<?> list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String collectionToString(Collection<?> collection, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static byte[] getUTF8Bytes(String s) {
        int length;
        if (s == null || (length = s.length()) == 0) {
            return new byte[0];
        }
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                try {
                    return s.getBytes("UTF-8");
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return s.getBytes();
                }
            }
            b[i] = (byte)(c & 0x7F);
        }
        return b;
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(t, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(t.getClass().getSimpleName());
        buffer.append('(');
        String message = t.getMessage();
        if (message != null) {
            buffer.append("message='");
            buffer.append(message);
            buffer.append("', ");
        }
        buffer.append("trace='");
        StaticUtils.getStackTrace(t.getStackTrace(), buffer);
        buffer.append('\'');
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(", cause=");
            StaticUtils.getStackTrace(cause, buffer);
        }
        buffer.append(", revision=");
        buffer.append("80fe8");
        buffer.append(')');
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(elements, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(StackTraceElement[] elements, StringBuilder buffer) {
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            buffer.append(elements[i].getMethodName());
            buffer.append('(');
            buffer.append(elements[i].getFileName());
            int lineNumber = elements[i].getLineNumber();
            if (lineNumber > 0) {
                buffer.append(':');
                buffer.append(lineNumber);
            }
            buffer.append(')');
        }
    }

    public static Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        ArrayList<Throwable> chain = new ArrayList<Throwable>(10);
        for (Throwable current = t; current != null && !chain.contains(current); current = current.getCause()) {
            chain.add(current);
        }
        if (chain.size() < 2) {
            return t;
        }
        return (Throwable)chain.get(chain.size() - 1);
    }
}

