/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.tools;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.ResourceNotFoundException;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMService;
import com.unboundid.scim.tools.QueryRateThread;
import com.unboundid.scim.tools.ToolMessages;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.WakeableSleeper;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PromptTrustManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.ConsoleHandler;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MediaType;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMQueryRate
extends CommandLineTool {
    private FileArgument authPasswordFile;
    private IntegerArgument port;
    private StringArgument authID;
    private StringArgument authPassword;
    private StringArgument bearerToken;
    private StringArgument contextPath;
    private StringArgument host;
    private BooleanArgument trustAll;
    private BooleanArgument useSSL;
    private FileArgument keyStorePasswordFile;
    private FileArgument trustStorePasswordFile;
    private StringArgument certificateNickname;
    private StringArgument keyStoreFormat;
    private StringArgument keyStorePath;
    private StringArgument keyStorePassword;
    private StringArgument trustStoreFormat;
    private StringArgument trustStorePath;
    private StringArgument trustStorePassword;
    private BooleanArgument csvFormat;
    private BooleanArgument xmlFormat;
    private IntegerArgument collectionInterval;
    private IntegerArgument numIntervals;
    private IntegerArgument numThreads;
    private IntegerArgument randomSeed;
    private IntegerArgument ratePerSecond;
    private IntegerArgument warmUpIntervals;
    private StringArgument attributes;
    private StringArgument filter;
    private StringArgument resourceId;
    private StringArgument resourceName;
    private StringArgument timestampFormat;
    private final AtomicReference<PromptTrustManager> promptTrustManager = new AtomicReference();

    public static void main(String[] args) {
        ResultCode resultCode = SCIMQueryRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        SCIMQueryRate queryRate = new SCIMQueryRate(outStream, errStream);
        return queryRate.runTool(args);
    }

    public SCIMQueryRate(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    public String getToolName() {
        return "scim-query-rate";
    }

    public String getToolDescription() {
        return ToolMessages.INFO_QUERY_TOOL_DESC.get();
    }

    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.host = new StringArgument(Character.valueOf('h'), "hostname", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_HOSTNAME.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_HOSTNAME.get(), "localhost");
        parser.addArgument((Argument)this.host);
        this.port = new IntegerArgument(Character.valueOf('p'), "port", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_PORT.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_PORT.get(), 1, 65535, Integer.valueOf(80));
        parser.addArgument((Argument)this.port);
        this.contextPath = new StringArgument(null, "contextPath", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_CONTEXT_PATH.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_CONTEXT_PATH.get(), Arrays.asList("/"));
        parser.addArgument((Argument)this.contextPath);
        this.authID = new StringArgument(null, "authID", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTHID.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_AUTHID.get());
        parser.addArgument((Argument)this.authID);
        this.authPassword = new StringArgument(Character.valueOf('w'), "authPassword", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD.get());
        parser.addArgument((Argument)this.authPassword);
        this.bearerToken = new StringArgument(null, "bearerToken", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_BEARER_TOKEN.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_BEARER_TOKEN.get());
        parser.addArgument((Argument)this.bearerToken);
        this.authPasswordFile = new FileArgument(Character.valueOf('j'), "authPasswordFile", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD_FILE.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD_FILE.get(), true, true, true, false);
        parser.addArgument((Argument)this.authPasswordFile);
        this.resourceName = new StringArgument(null, "resourceName", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_NAME.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_RESOURCE_NAME.get(), null, Arrays.asList("User"));
        parser.addArgument((Argument)this.resourceName);
        this.xmlFormat = new BooleanArgument(Character.valueOf('x'), "xml", 1, ToolMessages.INFO_QUERY_TOOL_ARG_DESC_XML_FORMAT.get());
        parser.addArgument((Argument)this.xmlFormat);
        this.filter = new StringArgument(Character.valueOf('f'), "filter", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_FILTER.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_FILTER.get());
        parser.addArgument((Argument)this.filter);
        this.resourceId = new StringArgument(Character.valueOf('d'), "resourceID", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_ID.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_RESOURCE_ID.get());
        parser.addArgument((Argument)this.resourceId);
        this.attributes = new StringArgument(Character.valueOf('A'), "attribute", false, 0, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_ATTRIBUTE.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_ATTRIBUTE.get());
        parser.addArgument((Argument)this.attributes);
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_THREADS.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, Integer.valueOf(1));
        parser.addArgument((Argument)this.numThreads);
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_INTERVAL_DURATION.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_INTERVAL_DURATION.get(), 1, Integer.MAX_VALUE, Integer.valueOf(5));
        parser.addArgument((Argument)this.collectionInterval);
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_INTERVALS.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_NUM_INTERVALS.get(), 1, Integer.MAX_VALUE, Integer.valueOf(Integer.MAX_VALUE));
        parser.addArgument((Argument)this.numIntervals);
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_RATE_PER_SECOND.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_RATE_PER_SECOND.get(), 1, Integer.MAX_VALUE);
        parser.addArgument((Argument)this.ratePerSecond);
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_WARM_UP_INTERVALS.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_WARM_UP_INTERVALS.get(), 0, Integer.MAX_VALUE, Integer.valueOf(0));
        parser.addArgument((Argument)this.warmUpIntervals);
        LinkedHashSet<String> allowedFormats = new LinkedHashSet<String>(3);
        allowedFormats.add("none");
        allowedFormats.add("with-date");
        allowedFormats.add("without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_TIMESTAMP_FORMAT.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_TIMESTAMP_FORMAT.get(), allowedFormats, "none");
        parser.addArgument((Argument)this.timestampFormat);
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, ToolMessages.INFO_QUERY_TOOL_ARG_DESC_CSV_FORMAT.get());
        parser.addArgument((Argument)this.csvFormat);
        this.randomSeed = new IntegerArgument(Character.valueOf('R'), "randomSeed", false, 1, ToolMessages.INFO_QUERY_TOOL_ARG_PLACEHOLDER_RANDOM_SEED.get(), ToolMessages.INFO_QUERY_TOOL_ARG_DESC_RANDOM_SEED.get());
        parser.addArgument((Argument)this.randomSeed);
        this.useSSL = new BooleanArgument(Character.valueOf('Z'), "useSSL", 1, ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_USE_SSL.get());
        parser.addArgument((Argument)this.useSSL);
        this.trustAll = new BooleanArgument(Character.valueOf('X'), "trustAll", 1, ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_TRUST_ALL.get());
        parser.addArgument((Argument)this.trustAll);
        this.keyStorePath = new StringArgument(Character.valueOf('K'), "keyStorePath", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PATH.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PATH.get());
        parser.addArgument((Argument)this.keyStorePath);
        this.keyStorePassword = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PASSWORD.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD.get());
        parser.addArgument((Argument)this.keyStorePassword);
        this.keyStorePasswordFile = new FileArgument(Character.valueOf('u'), "keyStorePasswordFile", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PATH.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE.get());
        parser.addArgument((Argument)this.keyStorePasswordFile);
        this.keyStoreFormat = new StringArgument(null, "keyStoreFormat", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_FORMAT.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_FORMAT.get());
        parser.addArgument((Argument)this.keyStoreFormat);
        this.trustStorePath = new StringArgument(Character.valueOf('P'), "trustStorePath", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PATH.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PATH.get());
        parser.addArgument((Argument)this.trustStorePath);
        this.trustStorePassword = new StringArgument(Character.valueOf('T'), "trustStorePassword", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PASSWORD.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD.get());
        parser.addArgument((Argument)this.trustStorePassword);
        this.trustStorePasswordFile = new FileArgument(Character.valueOf('U'), "trustStorePasswordFile", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_PATH.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE.get());
        parser.addArgument((Argument)this.trustStorePasswordFile);
        this.trustStoreFormat = new StringArgument(null, "trustStoreFormat", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_FORMAT.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_FORMAT.get());
        parser.addArgument((Argument)this.trustStoreFormat);
        this.certificateNickname = new StringArgument(Character.valueOf('N'), "certNickname", false, 1, ToolMessages.INFO_SCIM_TOOL_PLACEHOLDER_CERT_NICKNAME.get(), ToolMessages.INFO_SCIM_TOOL_DESCRIPTION_CERT_NICKNAME.get());
        parser.addArgument((Argument)this.certificateNickname);
        parser.addDependentArgumentSet((Argument)this.authID, (Argument)this.authPassword, new Argument[]{this.authPasswordFile});
        parser.addExclusiveArgumentSet((Argument)this.authPassword, (Argument)this.authPasswordFile, new Argument[]{this.bearerToken});
        parser.addExclusiveArgumentSet((Argument)this.authID, (Argument)this.bearerToken, new Argument[0]);
        parser.addExclusiveArgumentSet((Argument)this.keyStorePassword, (Argument)this.keyStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet((Argument)this.trustStorePassword, (Argument)this.trustStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet((Argument)this.trustAll, (Argument)this.trustStorePath, new Argument[0]);
        parser.addExclusiveArgumentSet((Argument)this.filter, (Argument)this.resourceId, new Argument[0]);
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        String[] args1 = new String[]{"--hostname", "server.example.com", "--port", "80", "--authID", "admin", "--authPassword", "password", "--xml", "--filter", "userName eq \"user.[1-1000000]\"", "--attribute", "userName", "--attribute", "name", "--numThreads", "8"};
        examples.put(args1, ToolMessages.INFO_QUERY_TOOL_EXAMPLE_1.get());
        String[] args2 = new String[]{"--hostname", "server.example.com", "--port", "80", "--authID", "admin", "--authPassword", "password", "--resourceID", "uid=user.[1-1000000],ou=people,dc=example,dc=com", "--attribute", "userName", "--attribute", "name", "--numThreads", "8"};
        examples.put(args2, ToolMessages.INFO_QUERY_TOOL_EXAMPLE_2.get());
        return examples;
    }

    public ResultCode doToolProcessing() {
        ResourceDescriptor resourceDescriptor;
        URI uri;
        String schemeName;
        SSLUtil sslUtil;
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        String[] attrs;
        ValuePattern filterPattern;
        Debug.setEnabled(true);
        Debug.getLogger().addHandler(new ConsoleHandler());
        Debug.getLogger().setUseParentHandlers(false);
        Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().intValue()) : null;
        boolean isQuery = true;
        if (this.filter.isPresent()) {
            try {
                filterPattern = new ValuePattern(this.filter.getValue(), seed);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                this.err(new Object[]{ToolMessages.ERR_QUERY_TOOL_BAD_FILTER_PATTERN.get(pe.getMessage())});
                return ResultCode.PARAM_ERROR;
            }
        } else if (this.resourceId.isPresent()) {
            isQuery = false;
            try {
                filterPattern = new ValuePattern(this.resourceId.getValue());
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                this.err(new Object[]{ToolMessages.ERR_QUERY_TOOL_BAD_RESOURCE_ID_PATTERN.get(pe.getMessage())});
                return ResultCode.PARAM_ERROR;
            }
        } else {
            filterPattern = null;
        }
        if (this.attributes.isPresent()) {
            List attrList = this.attributes.getValues();
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        } else {
            attrs = StaticUtils.NO_STRINGS;
        }
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn[]{new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Recent", "Queries/Sec"}), new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Recent", "Avg Dur ms"}), new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Recent", "Resources/Query"}), new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Recent", "Errors/Sec"}), new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Overall", "Queries/Sec"}), new FormattableColumn(15, HorizontalAlignment.RIGHT, new String[]{"Overall", "Avg Dur ms"})});
        AtomicLong queryCounter = new AtomicLong(0L);
        AtomicLong resourceCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong queryDurations = new AtomicLong(0L);
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        try {
            sslUtil = this.createSSLUtil();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.err(new Object[]{e.getMessage()});
            return e.getResultCode();
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (sslUtil != null) {
            try {
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslUtil.createSSLContext("TLS"), (HostnameVerifier)new NoopHostnameVerifier());
                schemeName = "https";
                registryBuilder.register(schemeName, (Object)sslConnectionSocketFactory);
            }
            catch (GeneralSecurityException e) {
                Debug.debugException(e);
                this.err(new Object[]{ToolMessages.ERR_SCIM_TOOL_CANNOT_CREATE_SSL_CONTEXT.get(StaticUtils.getExceptionMessage((Throwable)e))});
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            schemeName = "http";
            registryBuilder.register(schemeName, (Object)new PlainConnectionSocketFactory());
        }
        Registry socketFactoryRegistry = registryBuilder.build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setExpectContinueEnabled(true).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(30000).setSoReuseAddress(true).build();
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        mgr.setMaxTotal(this.numThreads.getValue().intValue());
        mgr.setDefaultMaxPerRoute(this.numThreads.getValue().intValue());
        mgr.setDefaultSocketConfig(socketConfig);
        mgr.setValidateAfterInactivity(-1);
        ClientConfig jerseyConfig = new ClientConfig();
        jerseyConfig.property("jersey.config.apache.client.connectionManager", (Object)mgr);
        jerseyConfig.property("jersey.config.apache.client.requestConfig", (Object)requestConfig);
        ApacheConnectorProvider connectorProvider = new ApacheConnectorProvider();
        jerseyConfig.connectorProvider((ConnectorProvider)connectorProvider);
        if (this.authID.isPresent()) {
            try {
                String password = this.authPassword.isPresent() ? this.authPassword.getValue() : (this.authPasswordFile.isPresent() ? (String)this.authPasswordFile.getNonBlankFileLines().get(0) : null);
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(this.host.getValue(), this.port.getValue().intValue()), (Credentials)new UsernamePasswordCredentials(this.authID.getValue(), password));
                jerseyConfig.property("jersey.config.apache.client.credentialsProvider", (Object)provider);
                jerseyConfig.property("jersey.config.apache.client.preemptiveBasicAuthentication", (Object)true);
            }
            catch (IOException e) {
                Debug.debugException(e);
                this.err(new Object[]{ToolMessages.ERR_QUERY_TOOL_SET_BASIC_AUTH.get(e.getMessage())});
                return ResultCode.LOCAL_ERROR;
            }
        } else if (this.bearerToken.isPresent()) {
            jerseyConfig.register((Object)new ClientRequestFilter(){

                public void filter(ClientRequestContext clientRequestContext) throws IOException {
                    try {
                        clientRequestContext.getHeaders().add((Object)"Authorization", (Object)("Bearer " + SCIMQueryRate.this.bearerToken.getValue()));
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to add authorization handler", ex);
                    }
                }
            });
        }
        try {
            String path = this.contextPath.getValue().startsWith("/") ? this.contextPath.getValue() : "/" + this.contextPath.getValue();
            uri = new URI(schemeName, null, this.host.getValue(), this.port.getValue(), path, null, null);
        }
        catch (URISyntaxException e) {
            Debug.debugException(e);
            this.err(new Object[]{ToolMessages.ERR_QUERY_TOOL_CANNOT_CREATE_URL.get(e.getMessage())});
            return ResultCode.OTHER;
        }
        SCIMService service = new SCIMService(uri, jerseyConfig);
        if (this.xmlFormat.isPresent()) {
            service.setContentType(MediaType.APPLICATION_XML_TYPE);
            service.setAcceptType(MediaType.APPLICATION_XML_TYPE);
        }
        try {
            resourceDescriptor = service.getResourceDescriptor(this.resourceName.getValue(), null);
            if (resourceDescriptor == null) {
                throw new ResourceNotFoundException("Resource " + this.resourceName.getValue() + " is not defined by the service provider");
            }
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            this.err(new Object[]{ToolMessages.ERR_QUERY_TOOL_RETRIEVE_RESOURCE_SCHEMA.get(e.getMessage())});
            return ResultCode.OTHER;
        }
        SCIMEndpoint<BaseResource> endpoint = service.getEndpoint(resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        QueryRateThread[] threads = new QueryRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new QueryRateThread(i, isQuery, endpoint, filterPattern, attrs, barrier, queryCounter, resourceCounter, queryDurations, errorCounter, fixedRateBarrier);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(new Object[]{headerLine});
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumEntries = 0L;
        long lastNumErrors = 0L;
        long lastNumSearches = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            double recentAvgDuration;
            double recentEntriesPerSearch;
            long totalDuration;
            long numErrors;
            long numEntries;
            long numSearches;
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            try {
                if (sleepTimeMillis > 0L) {
                    Thread.sleep(sleepTimeMillis);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numSearches = queryCounter.getAndSet(0L);
                numEntries = resourceCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = queryDurations.getAndSet(0L);
            } else {
                numSearches = queryCounter.get();
                numEntries = resourceCounter.get();
                numErrors = errorCounter.get();
                totalDuration = queryDurations.get();
            }
            long recentNumSearches = numSearches - lastNumSearches;
            long recentNumEntries = numEntries - lastNumEntries;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentSearchRate = (double)recentNumSearches / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            if (recentNumSearches > 0L) {
                recentEntriesPerSearch = 1.0 * (double)recentNumEntries / (double)recentNumSearches;
                recentAvgDuration = 1.0 * (double)recentDuration / (double)recentNumSearches / 1000000.0;
            } else {
                recentEntriesPerSearch = 0.0;
                recentAvgDuration = 0.0;
            }
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(new Object[]{formatter.formatRow(new Object[]{recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, "warming up", "warming up"})});
                if (--remainingWarmUpIntervals == 0) {
                    this.out(new Object[]{ToolMessages.INFO_QUERY_TOOL_WARM_UP_COMPLETED.get()});
                    setOverallStartTime = true;
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallSearchRate = (double)numSearches / numOverallSeconds;
                double overallAvgDuration = numSearches > 0L ? 1.0 * (double)totalDuration / (double)numSearches / 1000000.0 : 0.0;
                this.out(new Object[]{formatter.formatRow(new Object[]{recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, overallSearchRate, overallAvgDuration})});
                lastNumSearches = numSearches;
                lastNumEntries = numEntries;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            lastEndTime = endTime;
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (QueryRateThread t : threads) {
            t.signalShutdown();
        }
        WakeableSleeper sleeper = new WakeableSleeper();
        sleeper.sleep(1000L);
        mgr.shutdown();
        for (QueryRateThread t : threads) {
            ResultCode r = t.waitForShutdown();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    private SSLUtil createSSLUtil() throws LDAPException {
        if (this.useSSL.isPresent()) {
            Object trustManager;
            KeyStoreKeyManager keyManager = null;
            if (this.keyStorePath.isPresent()) {
                char[] pw = null;
                if (this.keyStorePassword.isPresent()) {
                    pw = this.keyStorePassword.getValue().toCharArray();
                } else if (this.keyStorePasswordFile.isPresent()) {
                    try {
                        pw = ((String)this.keyStorePasswordFile.getNonBlankFileLines().get(0)).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_SCIM_TOOL_CANNOT_READ_KEY_STORE_PASSWORD.get(StaticUtils.getExceptionMessage((Throwable)e)), (Throwable)e);
                    }
                }
                try {
                    keyManager = new KeyStoreKeyManager(this.keyStorePath.getValue(), pw, this.keyStoreFormat.getValue(), this.certificateNickname.getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_SCIM_TOOL_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage((Throwable)e)), (Throwable)e);
                }
            }
            if (this.trustAll.isPresent()) {
                trustManager = new TrustAllTrustManager(false);
            } else if (this.trustStorePath.isPresent()) {
                char[] pw = null;
                if (this.trustStorePassword.isPresent()) {
                    pw = this.trustStorePassword.getValue().toCharArray();
                } else if (this.trustStorePasswordFile.isPresent()) {
                    try {
                        pw = ((String)this.trustStorePasswordFile.getNonBlankFileLines().get(0)).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_SCIM_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD.get(StaticUtils.getExceptionMessage((Throwable)e)), (Throwable)e);
                    }
                }
                trustManager = new TrustStoreTrustManager(this.trustStorePath.getValue(), pw, this.trustStoreFormat.getValue(), true);
            } else {
                trustManager = (TrustManager)this.promptTrustManager.get();
                if (trustManager == null) {
                    PromptTrustManager m = new PromptTrustManager();
                    this.promptTrustManager.compareAndSet(null, m);
                    trustManager = (TrustManager)this.promptTrustManager.get();
                }
            }
            return new SSLUtil(keyManager, (TrustManager)trustManager);
        }
        return null;
    }
}

