/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DebugType;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.ForbiddenException;
import com.unboundid.scim.sdk.GetResourceRequest;
import com.unboundid.scim.sdk.GetResourcesRequest;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.NotModifiedException;
import com.unboundid.scim.sdk.OAuthToken;
import com.unboundid.scim.sdk.OAuthTokenHandler;
import com.unboundid.scim.sdk.OAuthTokenStatus;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.PatchResourceRequest;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PreconditionFailedException;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.ResourceNotFoundException;
import com.unboundid.scim.sdk.ResourceSchemaBackend;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilter;
import com.unboundid.scim.sdk.SCIMQueryAttributes;
import com.unboundid.scim.sdk.SCIMRequest;
import com.unboundid.scim.sdk.SortParameters;
import com.unboundid.scim.sdk.UnauthorizedException;
import com.unboundid.scim.wink.AbstractStaticResource;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.SCIMApplication;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSCIMResource
extends AbstractStaticResource {
    private final SCIMApplication application;
    private static final Set<String> SEARCH_REQUEST_PARAMS;
    private static final Set<String> COMMON_REQUEST_PARAMS;
    private final OAuthTokenHandler tokenHandler;
    private final ResourceSchemaBackend resourceSchemaBackend;

    public AbstractSCIMResource(SCIMApplication application, OAuthTokenHandler tokenHandler) {
        this.application = application;
        this.tokenHandler = tokenHandler;
        this.resourceSchemaBackend = new ResourceSchemaBackend(application);
    }

    Response getUser(RequestContext requestContext, String endpoint, String userID) {
        Response.ResponseBuilder responseBuilder;
        block9: {
            this.logIgnoredQueryParams(requestContext, COMMON_REQUEST_PARAMS);
            ResourceDescriptor resourceDescriptor = null;
            try {
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
                SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(resourceDescriptor, attributes);
                GetResourceRequest getResourceRequest = new GetResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, queryAttributes, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, getResourceRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("get-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    getResourceRequest = new GetResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, queryAttributes, requestContext.getRequest());
                }
                BaseResource resource = backend.getResource(getResourceRequest);
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
                AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resource);
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("get-successful");
                responseBuilder.contentLocation(resource.getMeta().getLocation());
                responseBuilder.header("ETag", (Object)resource.getMeta().getVersion());
                if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("get-response-json");
                } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("get-response-xml");
                }
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                responseBuilder = this.error(e, requestContext);
                if (resourceDescriptor == null) break block9;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("get-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    protected Response getUsers(RequestContext requestContext, String endpoint, String filterString, String baseID, String searchScope, String sortBy, String sortOrder, String pageStartIndex, String pageSize) {
        Response.ResponseBuilder responseBuilder;
        block17: {
            this.logIgnoredQueryParams(requestContext, SEARCH_REQUEST_PARAMS);
            ResourceDescriptor resourceDescriptor = null;
            try {
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
                SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(resourceDescriptor, attributes);
                SCIMFilter filter = this.parseFilter(filterString, resourceDescriptor);
                SortParameters sortParameters = sortBy != null && !sortBy.isEmpty() ? new SortParameters(AttributePath.parse(sortBy, resourceDescriptor.getSchema()), sortOrder) : null;
                int startIndex = -1;
                int count = -1;
                if (pageStartIndex != null && !pageStartIndex.isEmpty()) {
                    try {
                        startIndex = Integer.parseInt(pageStartIndex);
                    }
                    catch (NumberFormatException e) {
                        Debug.debugException(e);
                        throw new InvalidResourceException("The pagination startIndex value '" + pageStartIndex + "' is not parsable");
                    }
                    if (startIndex <= 0) {
                        throw new InvalidResourceException("The pagination startIndex value '" + pageStartIndex + "' is invalid because it is not greater than zero");
                    }
                }
                if (pageSize != null && !pageSize.isEmpty()) {
                    try {
                        count = Integer.parseInt(pageSize);
                    }
                    catch (NumberFormatException e) {
                        Debug.debugException(e);
                        throw new InvalidResourceException("The pagination count value '" + pageSize + "' is not parsable");
                    }
                    if (count <= 0) {
                        throw new InvalidResourceException("The pagination count value '" + pageSize + "' is invalid because it is not greater than zero");
                    }
                }
                PageParameters pageParameters = startIndex >= 0 && count >= 0 ? new PageParameters(startIndex, count) : (startIndex >= 0 ? new PageParameters(startIndex, 0) : (count >= 0 ? new PageParameters(1, count) : null));
                GetResourcesRequest getResourcesRequest = new GetResourcesRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, filter, baseID, searchScope, sortParameters, pageParameters, queryAttributes, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, getResourcesRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("query-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    getResourcesRequest = new GetResourcesRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, filter, baseID, searchScope, sortParameters, pageParameters, queryAttributes, requestContext.getRequest());
                }
                Resources resources = backend.getResources(getResourcesRequest);
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
                AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resources);
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("query-successful");
                if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("query-response-json");
                } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("query-response-xml");
                }
            }
            catch (SCIMException e) {
                responseBuilder = Response.status((int)e.getStatusCode());
                AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
                if (resourceDescriptor == null) break block17;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("query-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    Response postUser(RequestContext requestContext, String endpoint, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        block11: {
            this.logIgnoredQueryParams(requestContext, COMMON_REQUEST_PARAMS);
            ResourceDescriptor resourceDescriptor = null;
            try {
                Unmarshaller unmarshaller;
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    unmarshaller = new JsonUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-content-json");
                } else {
                    unmarshaller = new XmlUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-content-xml");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                BaseResource postedResource = unmarshaller.unmarshal(inputStream, resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
                String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
                SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(resourceDescriptor, attributes);
                PostResourceRequest postResourceRequest = new PostResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, postedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, postResourceRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    postResourceRequest = new PostResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, postedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                }
                BaseResource resource = backend.postResource(postResourceRequest);
                responseBuilder = Response.status((Response.Status)Response.Status.CREATED);
                AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resource);
                responseBuilder.location(resource.getMeta().getLocation());
                responseBuilder.header("ETag", (Object)resource.getMeta().getVersion());
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-successful");
                if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-response-json");
                } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-response-xml");
                }
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                responseBuilder = this.error(e, requestContext);
                if (resourceDescriptor == null) break block11;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("post-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    Response putUser(RequestContext requestContext, String endpoint, String userID, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        block11: {
            this.logIgnoredQueryParams(requestContext, COMMON_REQUEST_PARAMS);
            ResourceDescriptor resourceDescriptor = null;
            try {
                Unmarshaller unmarshaller;
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    unmarshaller = new JsonUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-content-json");
                } else {
                    unmarshaller = new XmlUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-content-xml");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                BaseResource puttedResource = unmarshaller.unmarshal(inputStream, resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
                String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
                SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(resourceDescriptor, attributes);
                PutResourceRequest putResourceRequest = new PutResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, puttedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, putResourceRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    putResourceRequest = new PutResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, puttedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                }
                BaseResource scimResponse = backend.putResource(putResourceRequest);
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
                AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), scimResponse);
                responseBuilder.contentLocation(scimResponse.getMeta().getLocation());
                responseBuilder.header("ETag", (Object)scimResponse.getMeta().getVersion());
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-successful");
                if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-response-json");
                } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-response-xml");
                }
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                responseBuilder = this.error(e, requestContext);
                if (resourceDescriptor == null) break block11;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("put-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    Response patchUser(RequestContext requestContext, String endpoint, String userID, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        block13: {
            this.logIgnoredQueryParams(requestContext, COMMON_REQUEST_PARAMS);
            ResourceDescriptor resourceDescriptor = null;
            try {
                Unmarshaller unmarshaller;
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    unmarshaller = new JsonUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-content-json");
                } else {
                    unmarshaller = new XmlUnmarshaller();
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-content-xml");
                }
                BaseResource patchedResource = unmarshaller.unmarshal(inputStream, resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
                String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
                SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(resourceDescriptor, attributes);
                PatchResourceRequest patchResourceRequest = new PatchResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, patchedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, patchResourceRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    patchResourceRequest = new PatchResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, patchedResource.getScimObject(), queryAttributes, requestContext.getRequest());
                }
                BaseResource scimResponse = backend.patchResource(patchResourceRequest);
                if (!queryAttributes.allAttributesRequested()) {
                    responseBuilder = Response.status((Response.Status)Response.Status.OK);
                    AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), scimResponse);
                } else {
                    responseBuilder = Response.status((Response.Status)Response.Status.NO_CONTENT);
                }
                responseBuilder.contentLocation(scimResponse.getMeta().getLocation());
                responseBuilder.header("ETag", (Object)scimResponse.getMeta().getVersion());
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-successful");
                if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-response-json");
                } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
                    this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-response-xml");
                }
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                responseBuilder = this.error(e, requestContext);
                if (resourceDescriptor == null) break block13;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("patch-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    Response deleteUser(RequestContext requestContext, String endpoint, String userID) {
        Response.ResponseBuilder responseBuilder;
        block6: {
            ResourceDescriptor resourceDescriptor = null;
            try {
                SCIMBackend backend = this.getBackend(endpoint);
                resourceDescriptor = backend.getResourceDescriptor(endpoint);
                if (resourceDescriptor == null) {
                    throw new ResourceNotFoundException(endpoint + " is not a valid resource endpoint");
                }
                String authID = requestContext.getAuthID();
                if (authID == null && this.tokenHandler == null) {
                    throw new UnauthorizedException("Invalid credentials");
                }
                DeleteResourceRequest deleteResourceRequest = new DeleteResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, requestContext.getRequest());
                if (authID == null) {
                    AtomicReference<String> authIDRef = new AtomicReference<String>();
                    Response response = AbstractSCIMResource.validateOAuthToken(requestContext, deleteResourceRequest, authIDRef, this.tokenHandler);
                    if (response != null) {
                        this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("delete-" + response.getStatus());
                        return response;
                    }
                    authID = authIDRef.get();
                    deleteResourceRequest = new DeleteResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, resourceDescriptor, userID, requestContext.getRequest());
                }
                backend.deleteResource(deleteResourceRequest);
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("delete-successful");
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                responseBuilder = this.error(e, requestContext);
                if (resourceDescriptor == null) break block6;
                this.application.getStatsForResource(resourceDescriptor.getName()).incrementStat("delete-" + e.getStatusCode());
            }
        }
        return responseBuilder.build();
    }

    static Response validateOAuthToken(RequestContext context, SCIMRequest request, AtomicReference<String> authIDRef, OAuthTokenHandler tokenHandlerImpl) {
        HttpHeaders headers = context.getHeaders();
        List headerList = headers.getRequestHeader("Authorization");
        if (headerList == null || headerList.isEmpty()) {
            Response.ResponseBuilder builder = Response.status((int)401);
            builder.header("WWW-Authenticate", (Object)"Bearer realm=\"SCIM\"");
            return builder.build();
        }
        if (headerList.size() > 1) {
            return AbstractSCIMResource.invalidRequest("The Authorization header has too many values", context.getProduceMediaType());
        }
        String header = (String)headerList.get(0);
        String[] authorization = header.split(" ");
        if (authorization.length == 2 && authorization[0].equalsIgnoreCase("Bearer") && authorization[1].length() > 0) {
            try {
                OAuthToken token = tokenHandlerImpl.decodeOAuthToken(authorization[1]);
                if (token == null) {
                    return AbstractSCIMResource.invalidRequest("Could not decode the access token", context.getProduceMediaType());
                }
                if (!tokenHandlerImpl.isTokenAuthentic(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is not authentic", context.getProduceMediaType());
                }
                if (!tokenHandlerImpl.isTokenForThisServer(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is not intended for this server", context.getProduceMediaType());
                }
                if (tokenHandlerImpl.isTokenExpired(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is expired", context.getProduceMediaType());
                }
                OAuthTokenStatus status = tokenHandlerImpl.validateToken(token, request);
                if (status.getErrorCode().equals((Object)OAuthTokenStatus.ErrorCode.INVALID_TOKEN)) {
                    String errorDescription = status.getErrorDescription();
                    return AbstractSCIMResource.invalidToken(errorDescription, context.getProduceMediaType());
                }
                if (status.getErrorCode().equals((Object)OAuthTokenStatus.ErrorCode.INSUFFICIENT_SCOPE)) {
                    String errorDescription = status.getErrorDescription();
                    String scope = status.getScope();
                    return AbstractSCIMResource.insufficientScope(scope, errorDescription, context.getProduceMediaType());
                }
                String authID = tokenHandlerImpl.getAuthzDN(token);
                if (authID == null) {
                    return AbstractSCIMResource.invalidToken("The access token did not contain an authorization DN", context.getProduceMediaType());
                }
                authIDRef.set(authID);
                return null;
            }
            catch (Throwable t) {
                Debug.debugException(t);
                return AbstractSCIMResource.invalidRequest(t.getMessage(), context.getProduceMediaType());
            }
        }
        if (authorization.length == 2 && authorization[0].equalsIgnoreCase("Basic") && authorization[1].length() > 0) {
            Response.ResponseBuilder builder = Response.status((int)401);
            builder.header("WWW-Authenticate", (Object)"Basic realm=\"SCIM\"");
            UnauthorizedException exception = new UnauthorizedException(null);
            AbstractSCIMResource.setResponseEntity(builder, context.getProduceMediaType(), exception);
            return builder.build();
        }
        return AbstractSCIMResource.invalidRequest("The Authorization header was malformed", context.getProduceMediaType());
    }

    private static Response invalidRequest(String errorDescription, MediaType mediaType) {
        Response.ResponseBuilder builder = Response.status((int)400);
        String authHeaderValue = "Bearer realm=\"SCIM\", error=\"invalid_request\"";
        if (errorDescription != null && !errorDescription.isEmpty()) {
            authHeaderValue = authHeaderValue + ", error_description=\"" + errorDescription + "\"";
        }
        builder.header("WWW-Authenticate", (Object)authHeaderValue);
        InvalidResourceException exception = new InvalidResourceException(errorDescription);
        AbstractSCIMResource.setResponseEntity(builder, mediaType, exception);
        return builder.build();
    }

    private static Response invalidToken(String errorDescription, MediaType mediaType) {
        Response.ResponseBuilder builder = Response.status((int)401);
        String authHeaderValue = "Bearer realm=\"SCIM\", error=\"invalid_token\"";
        if (errorDescription != null && !errorDescription.isEmpty()) {
            authHeaderValue = authHeaderValue + ", error_description=\"" + errorDescription + "\"";
        }
        builder.header("WWW-Authenticate", (Object)authHeaderValue);
        UnauthorizedException exception = new UnauthorizedException(errorDescription);
        AbstractSCIMResource.setResponseEntity(builder, mediaType, exception);
        return builder.build();
    }

    private static Response insufficientScope(String scope, String errorDescription, MediaType mediaType) {
        Response.ResponseBuilder builder = Response.status((int)403);
        String authHeaderValue = "Bearer realm=\"SCIM\", error=\"insufficient_scope\"";
        if (errorDescription != null && !errorDescription.isEmpty()) {
            authHeaderValue = authHeaderValue + ", error_description=\"" + errorDescription + "\"";
        }
        if (scope != null && !scope.isEmpty()) {
            authHeaderValue = authHeaderValue + ", scope=\"" + scope + "\"";
        }
        builder.header("WWW-Authenticate", (Object)authHeaderValue);
        ForbiddenException exception = new ForbiddenException(errorDescription);
        AbstractSCIMResource.setResponseEntity(builder, mediaType, exception);
        return builder.build();
    }

    private SCIMBackend getBackend(String endpoint) {
        if (endpoint.equals("Schemas")) {
            return this.resourceSchemaBackend;
        }
        return this.application.getBackend();
    }

    private Response.ResponseBuilder error(SCIMException e, RequestContext requestContext) {
        Response.ResponseBuilder responseBuilder = Response.status((int)e.getStatusCode());
        if (e instanceof NotModifiedException) {
            responseBuilder.header("ETag", (Object)((NotModifiedException)e).getVersion());
        } else {
            if (e instanceof PreconditionFailedException) {
                responseBuilder.header("ETag", (Object)((PreconditionFailedException)e).getVersion());
            }
            AbstractSCIMResource.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
        }
        return responseBuilder;
    }

    private SCIMFilter parseFilter(String filterString, ResourceDescriptor resourceDescriptor) throws SCIMException {
        SCIMFilter filter = null;
        if (filterString != null && !filterString.isEmpty()) {
            filter = resourceDescriptor.getSchema().equalsIgnoreCase("urn:unboundid:schemas:scim:ldap:1.0") ? SCIMFilter.parse(filterString, resourceDescriptor.getSchema()) : SCIMFilter.parse(filterString);
        }
        return filter;
    }

    private void logIgnoredQueryParams(RequestContext requestContext, Set<String> supportedParams) {
        if (Debug.debugEnabled(DebugType.OTHER)) {
            HashSet<String> ignoredParams = new HashSet<String>();
            MultivaluedMap map = requestContext.getUriInfo().getQueryParameters();
            for (String param : map.keySet()) {
                if (supportedParams.contains(param.toLowerCase())) continue;
                ignoredParams.add(param);
            }
            if (!ignoredParams.isEmpty()) {
                Debug.debug(Level.WARNING, DebugType.OTHER, String.format("These request parameters were ignored: %s. Supported request parameters are: %s", ignoredParams, supportedParams));
            }
        }
    }

    static {
        TreeSet<String> params = new TreeSet<String>();
        params.add("attributes");
        params.add("filter");
        params.add("base-id");
        params.add("scope");
        params.add("sortby");
        params.add("sortorder");
        params.add("startindex");
        params.add("count");
        SEARCH_REQUEST_PARAMS = Collections.unmodifiableSet(params);
        params = new TreeSet();
        params.add("attributes");
        COMMON_REQUEST_PARAMS = Collections.unmodifiableSet(params);
    }
}

