/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.unboundid.scim2.client.ScimInterface;
import com.unboundid.scim2.client.requests.CreateRequestBuilder;
import com.unboundid.scim2.client.requests.DeleteRequestBuilder;
import com.unboundid.scim2.client.requests.ModifyRequestBuilder;
import com.unboundid.scim2.client.requests.ReplaceRequestBuilder;
import com.unboundid.scim2.client.requests.RetrieveRequestBuilder;
import com.unboundid.scim2.client.requests.SearchRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.net.URI;

public class ScimService
implements ScimInterface {
    @NotNull
    public static final URI ME_URI = URI.create("Me");
    @NotNull
    public static final MediaType MEDIA_TYPE_SCIM_TYPE = MediaType.valueOf((String)"application/scim+json");
    @NotNull
    private final WebTarget baseTarget;
    @Nullable
    private volatile ServiceProviderConfigResource serviceProviderConfig;

    public ScimService(@NotNull WebTarget baseTarget) {
        this.baseTarget = (WebTarget)baseTarget.register((Object)new JacksonJsonProvider(JsonUtils.createObjectMapper(), JacksonJsonProvider.BASIC_ANNOTATIONS));
    }

    @Override
    @NotNull
    public ServiceProviderConfigResource getServiceProviderConfig() throws ScimException {
        if (this.serviceProviderConfig == null) {
            this.serviceProviderConfig = this.retrieve(this.baseTarget.path("ServiceProviderConfig").getUri(), ServiceProviderConfigResource.class);
        }
        return this.serviceProviderConfig;
    }

    @Override
    @NotNull
    public ListResponse<ResourceTypeResource> getResourceTypes() throws ScimException {
        return this.searchRequest("ResourceTypes").invoke(ResourceTypeResource.class);
    }

    @Override
    @NotNull
    public ResourceTypeResource getResourceType(@NotNull String name) throws ScimException {
        return this.retrieve("ResourceTypes", name, ResourceTypeResource.class);
    }

    @Override
    @NotNull
    public ListResponse<SchemaResource> getSchemas() throws ScimException {
        return this.searchRequest("Schemas").invoke(SchemaResource.class);
    }

    @Override
    @NotNull
    public SchemaResource getSchema(@NotNull String id) throws ScimException {
        return this.retrieve("Schemas", id, SchemaResource.class);
    }

    @Override
    @NotNull
    public <T extends ScimResource> T create(@NotNull String endpoint, @NotNull T resource) throws ScimException {
        return this.createRequest(endpoint, resource).invoke();
    }

    @Override
    @NotNull
    public <T extends ScimResource> T retrieve(@NotNull String endpoint, @NotNull String id, @NotNull Class<T> cls) throws ScimException {
        return (T)((ScimResource)this.retrieveRequest(endpoint, id).invoke(cls));
    }

    @NotNull
    public <T extends ScimResource> T retrieve(@NotNull URI url, @NotNull Class<T> cls) throws ScimException {
        return (T)((ScimResource)this.retrieveRequest(url).invoke(cls));
    }

    @Override
    @NotNull
    public <T extends ScimResource> T retrieve(@NotNull T resource) throws ScimException {
        RetrieveRequestBuilder.Generic<T> builder = this.retrieveRequest(resource);
        return builder.invoke();
    }

    @Override
    @NotNull
    public <T extends ScimResource> T replace(@NotNull T resource) throws ScimException {
        ReplaceRequestBuilder<T> builder = this.replaceRequest(resource);
        return builder.invoke();
    }

    @Override
    public void delete(@NotNull String endpoint, @NotNull String id) throws ScimException {
        this.deleteRequest(endpoint, id).invoke();
    }

    public void delete(@NotNull URI url) throws ScimException {
        this.deleteRequest(url).invoke();
    }

    @Override
    public <T extends ScimResource> void delete(@NotNull T resource) throws ScimException {
        DeleteRequestBuilder builder = this.deleteRequest(resource);
        builder.invoke();
    }

    @NotNull
    public <T extends ScimResource> CreateRequestBuilder<T> createRequest(@NotNull String endpoint, @NotNull T resource) {
        return new CreateRequestBuilder<T>(this.baseTarget.path(endpoint), resource);
    }

    @NotNull
    public RetrieveRequestBuilder.Typed retrieveRequest(@NotNull String endpoint, @NotNull String id) {
        return new RetrieveRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
    }

    @NotNull
    public RetrieveRequestBuilder.Typed retrieveRequest(@NotNull URI url) {
        return new RetrieveRequestBuilder.Typed(this.resolveWebTarget(url));
    }

    @NotNull
    public <T extends ScimResource> RetrieveRequestBuilder.Generic<T> retrieveRequest(@NotNull T resource) {
        return new RetrieveRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    @NotNull
    public SearchRequestBuilder searchRequest(@NotNull String endpoint) {
        return new SearchRequestBuilder(this.baseTarget.path(endpoint));
    }

    @NotNull
    public <T extends ScimResource> ReplaceRequestBuilder<T> replaceRequest(@NotNull URI uri, @NotNull T resource) {
        return new ReplaceRequestBuilder<T>(this.resolveWebTarget(uri), resource);
    }

    @NotNull
    public <T extends ScimResource> ReplaceRequestBuilder<T> replaceRequest(@NotNull T resource) {
        return new ReplaceRequestBuilder<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    @Override
    @NotNull
    public <T extends ScimResource> T modify(@NotNull String endpoint, @NotNull String id, @NotNull PatchRequest patchRequest, @NotNull Class<T> clazz) throws ScimException {
        ModifyRequestBuilder.Typed requestBuilder = new ModifyRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
        for (PatchOperation op : patchRequest.getOperations()) {
            requestBuilder.addOperation(op);
        }
        return (T)((ScimResource)requestBuilder.invoke(clazz));
    }

    @NotNull
    public ModifyRequestBuilder.Typed modifyRequest(@NotNull String endpoint, @NotNull String id) {
        return new ModifyRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
    }

    @NotNull
    public ModifyRequestBuilder.Typed modifyRequest(@NotNull URI url) {
        return new ModifyRequestBuilder.Typed(this.resolveWebTarget(url));
    }

    @Override
    @NotNull
    public <T extends ScimResource> T modify(@NotNull T resource, @NotNull PatchRequest patchRequest) throws ScimException {
        ModifyRequestBuilder.Generic<T> requestBuilder = new ModifyRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
        for (PatchOperation op : patchRequest.getOperations()) {
            requestBuilder.addOperation(op);
        }
        return requestBuilder.invoke();
    }

    @NotNull
    public <T extends ScimResource> ModifyRequestBuilder.Generic<T> modifyRequest(@NotNull T resource) {
        return new ModifyRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    @NotNull
    public DeleteRequestBuilder deleteRequest(@NotNull String endpoint, @NotNull String id) throws ScimException {
        return new DeleteRequestBuilder(this.baseTarget.path(endpoint).path(id));
    }

    @NotNull
    public DeleteRequestBuilder deleteRequest(@NotNull URI url) throws ScimException {
        return new DeleteRequestBuilder(this.resolveWebTarget(url));
    }

    @NotNull
    public <T extends ScimResource> DeleteRequestBuilder deleteRequest(@NotNull T resource) throws ScimException {
        return this.deleteRequest(this.checkAndGetLocation(resource));
    }

    @NotNull
    private WebTarget resolveWebTarget(@NotNull URI url) {
        URI relativePath;
        if (url.isAbsolute()) {
            relativePath = this.baseTarget.getUri().relativize(url);
            if (relativePath.equals(url)) {
                throw new IllegalArgumentException("Given resource's location " + url + " is not under this service's base path " + this.baseTarget.getUri());
            }
        } else {
            relativePath = url;
        }
        return this.baseTarget.path(relativePath.getRawPath());
    }

    @NotNull
    private URI checkAndGetLocation(@NotNull ScimResource resource) throws IllegalArgumentException {
        Meta meta = resource.getMeta();
        if (meta == null || meta.getLocation() == null) {
            throw new IllegalArgumentException("Resource URI must be specified by meta.location");
        }
        return meta.getLocation();
    }

    @Override
    @NotNull
    public <T extends ScimResource> ListResponse<T> search(@NotNull String endpoint, @Nullable String filter, @NotNull Class<T> clazz) throws ScimException {
        return this.searchRequest(endpoint).filter(filter).invoke(clazz);
    }
}

