/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.exceptions.ScimException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;

public final class CreateRequestBuilder<T extends ScimResource>
extends ResourceReturningRequestBuilder<CreateRequestBuilder<T>> {
    @NotNull
    private final T resource;

    public CreateRequestBuilder(@NotNull WebTarget target, @NotNull T resource) {
        super(target);
        this.resource = resource;
    }

    @NotNull
    public T invoke() throws ScimException {
        return (T)((ScimResource)this.invoke(this.resource.getClass()));
    }

    @NotNull
    public <C> C invoke(@NotNull Class<C> cls) throws ScimException {
        try (Response response = this.buildRequest().post(Entity.entity(this.resource, (String)this.getContentType()));){
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                Object object = response.readEntity(cls);
                return (C)object;
            }
            throw CreateRequestBuilder.toScimException(response);
        }
    }
}

