/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.fasterxml.jackson.databind.JsonNode;
import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.utils.JsonUtils;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ModifyRequestBuilder<T extends ModifyRequestBuilder<T>>
extends ResourceReturningRequestBuilder<T> {
    @NotNull
    protected final List<PatchOperation> operations = new LinkedList<PatchOperation>();
    @Nullable
    protected String version;

    private ModifyRequestBuilder(@NotNull WebTarget target) {
        super(target);
    }

    @Override
    @NotNull
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    @NotNull
    public T replaceValue(@NotNull String path, @Nullable Object object) throws ScimException {
        return this.replaceValue(Path.fromString((String)path), object);
    }

    @NotNull
    public T replaceValue(@NotNull Path path, @Nullable Object object) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)object);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    @NotNull
    public T replaceValues(@NotNull String path, @Nullable Collection<Object> objects) throws ScimException {
        return this.replaceValues(Path.fromString((String)path), objects);
    }

    @NotNull
    public T replaceValues(@NotNull Path path, @Nullable Collection<Object> objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode(objects);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    @NotNull
    public T replaceValues(@NotNull String path, Object ... objects) throws ScimException {
        return this.replaceValues(Path.fromString((String)path), objects);
    }

    @NotNull
    public T replaceValues(@NotNull Path path, Object ... objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)objects);
        return this.addOperation(PatchOperation.replace((Path)path, (JsonNode)newObjectNode));
    }

    @NotNull
    public T addValues(@NotNull String path, @NotNull Collection<?> objects) throws ScimException {
        return this.addValues(Path.fromString((String)path), objects);
    }

    @NotNull
    public T addValues(@NotNull Path path, @NotNull Collection<?> objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode(objects);
        return this.addOperation(PatchOperation.add((Path)path, (JsonNode)newObjectNode));
    }

    @NotNull
    public T addValues(@NotNull String path, Object ... objects) throws ScimException {
        return this.addValues(Path.fromString((String)path), objects);
    }

    @NotNull
    public T addValues(@NotNull Path path, Object ... objects) {
        JsonNode newObjectNode = JsonUtils.valueToNode((Object)objects);
        return this.addOperation(PatchOperation.add((Path)path, (JsonNode)newObjectNode));
    }

    @NotNull
    public T removeValues(@NotNull String path) throws ScimException {
        return this.removeValues(Path.fromString((String)path));
    }

    @NotNull
    public T removeValues(@NotNull Path path) throws ScimException {
        return this.addOperation(PatchOperation.remove((Path)path));
    }

    @NotNull
    public T addOperation(@NotNull PatchOperation op) {
        this.operations.add(op);
        return (T)this;
    }

    public static final class Typed
    extends ModifyRequestBuilder<Typed> {
        public Typed(@NotNull WebTarget target) {
            super(target);
        }

        @NotNull
        public Typed ifMatch(@Nullable String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public <T> T invoke(@NotNull Class<T> cls) throws ScimException {
            PatchRequest patchRequest = new PatchRequest(this.operations);
            try (Response response = this.buildRequest().method("PATCH", Entity.entity((Object)patchRequest, (String)this.getContentType()));){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (T)object;
                }
                throw Typed.toScimException(response);
            }
        }
    }

    public static final class Generic<T extends ScimResource>
    extends ModifyRequestBuilder<Generic<T>> {
        @NotNull
        private final T resource;

        public Generic(@NotNull WebTarget target, @NotNull T resource) {
            super(target);
            this.resource = resource;
        }

        @NotNull
        public Generic<T> ifMatch() {
            this.version = Generic.getResourceVersion(this.resource);
            return this;
        }

        @NotNull
        public T invoke() throws ScimException {
            return (T)((ScimResource)this.invoke(this.resource.getClass()));
        }

        @NotNull
        public <C> C invoke(@NotNull Class<C> cls) throws ScimException {
            PatchRequest patchRequest = new PatchRequest(this.operations);
            try (Response response = this.buildRequest().method("PATCH", Entity.entity((Object)patchRequest, (String)this.getContentType()));){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (C)object;
                }
                throw Generic.toScimException(response);
            }
        }
    }
}

