/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;

public final class ReplaceRequestBuilder<T extends ScimResource>
extends ResourceReturningRequestBuilder<ReplaceRequestBuilder<T>> {
    @NotNull
    private final T resource;
    @Nullable
    private String version;

    public ReplaceRequestBuilder(@NotNull WebTarget target, @NotNull T resource) {
        super(target);
        this.resource = resource;
    }

    @NotNull
    public ReplaceRequestBuilder<T> ifMatch() {
        this.version = ReplaceRequestBuilder.getResourceVersion(this.resource);
        return this;
    }

    @Override
    @NotNull
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    @NotNull
    public T invoke() throws ScimException {
        return (T)((ScimResource)this.invoke(this.resource.getClass()));
    }

    @NotNull
    public <C> C invoke(@NotNull Class<C> cls) throws ScimException {
        try (Response response = this.buildRequest().put(Entity.entity(this.resource, (String)this.getContentType()));){
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                Object object = response.readEntity(cls);
                return (C)object;
            }
            throw ReplaceRequestBuilder.toScimException(response);
        }
    }
}

