/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.ScimServiceException;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.common.utils.StaticUtils;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestBuilder<T extends RequestBuilder> {
    @NotNull
    private WebTarget target;
    @NotNull
    protected final MultivaluedMap<String, Object> headers = new MultivaluedHashMap();
    @NotNull
    protected final MultivaluedMap<String, Object> queryParams = new MultivaluedHashMap();
    @Nullable
    private String contentType = "application/scim+json";
    @NotNull
    private List<String> accept = new ArrayList<String>();

    RequestBuilder(@NotNull WebTarget target) {
        this.target = target;
        this.accept("application/scim+json", "application/json");
    }

    @NotNull
    public T header(@NotNull String name, Object ... value) {
        this.headers.addAll((Object)name, value);
        return (T)this;
    }

    @NotNull
    public T contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return (T)this;
    }

    @NotNull
    public T accept(String ... acceptStrings) {
        this.accept.clear();
        if (acceptStrings == null || acceptStrings.length == 0) {
            throw new IllegalArgumentException("Accepted media types must not be null or empty");
        }
        for (String acceptString : acceptStrings) {
            this.accept.add(acceptString);
        }
        return (T)this;
    }

    @NotNull
    public T queryParam(@NotNull String name, Object ... value) {
        this.queryParams.addAll((Object)name, value);
        return (T)this;
    }

    @NotNull
    static String getResourceVersion(@NotNull ScimResource resource) throws IllegalArgumentException {
        if (resource == null || resource.getMeta() == null || resource.getMeta().getVersion() == null) {
            throw new IllegalArgumentException("Resource version must be specified by meta.version");
        }
        return resource.getMeta().getVersion();
    }

    @NotNull
    static ScimException toScimException(@NotNull Response response) {
        try {
            ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ScimException exception = errorResponse == null ? ScimException.createException((int)response.getStatus(), null) : ScimException.createException((ErrorResponse)errorResponse, null);
            response.close();
            return exception;
        }
        catch (ProcessingException ex) {
            String genericDetails = response.getStatusInfo().getReasonPhrase();
            return new ScimServiceException(response.getStatus(), genericDetails, ex);
        }
    }

    @NotNull
    protected WebTarget target() {
        return this.target;
    }

    @NotNull
    WebTarget buildTarget() {
        for (Map.Entry queryParam : this.queryParams.entrySet()) {
            this.target = this.target.queryParam((String)queryParam.getKey(), ((List)queryParam.getValue()).toArray());
        }
        return this.target;
    }

    @Nullable
    protected String getContentType() {
        return this.contentType;
    }

    @NotNull
    protected List<String> getAccept() {
        return this.accept;
    }

    @NotNull
    Invocation.Builder buildRequest() {
        Invocation.Builder builder = this.buildTarget().request(this.accept.toArray(new String[this.accept.size()]));
        for (Map.Entry header : this.headers.entrySet()) {
            builder = builder.header((String)header.getKey(), (Object)StaticUtils.listToString((List)((List)header.getValue()), (String)", "));
        }
        return builder;
    }
}

