/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.filters;

import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.utils.JsonUtils;

public abstract class ComparisonFilter
extends Filter {
    @NotNull
    private final Path filterAttribute;
    @NotNull
    private final ValueNode filterValue;

    ComparisonFilter(@NotNull Path filterAttribute, @Nullable ValueNode filterValue) {
        this.filterAttribute = filterAttribute;
        this.filterValue = filterValue == null ? JsonUtils.getJsonNodeFactory().nullNode() : filterValue;
    }

    @Override
    @Nullable
    public Path getAttributePath() {
        return this.filterAttribute;
    }

    @Override
    @Nullable
    public ValueNode getComparisonValue() {
        return this.filterValue;
    }

    @Override
    public boolean isComparisonFilter() {
        return true;
    }

    @Override
    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.filterAttribute);
        builder.append(' ');
        builder.append(this.getFilterType().getStringValue());
        builder.append(' ');
        builder.append(this.filterValue.toString());
    }
}

