/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.messages.SortOrder;
import java.util.Set;

@Schema(id="urn:ietf:params:scim:api:messages:2.0:SearchRequest", name="Search Operation", description="SCIM 2.0 Search Request")
public final class SearchRequest
extends BaseScimResource {
    @Nullable
    @Attribute(description="A multi-valued list of strings indicating the names of resource attributes to return in the response overriding the set of attributes that would be returned by default")
    @JsonProperty
    private final Set<String> attributes;
    @Nullable
    @Attribute(description="A multi-valued list of strings indicating the names of resource attributes to be removed from the default set of attributes to return")
    @JsonProperty
    private final Set<String> excludedAttributes;
    @Nullable
    @Attribute(description="The filter string used to request a subset of resources")
    @JsonProperty
    private final String filter;
    @Nullable
    @Attribute(description="A string indicating the attribute whose value shall be used to order the returned responses")
    @JsonProperty
    private final String sortBy;
    @Nullable
    @Attribute(description="A string indicating the order in which the sortBy parameter is applied")
    @JsonProperty
    private final SortOrder sortOrder;
    @Nullable
    @Attribute(description="An integer indicating the 1-based index of the first query result")
    @JsonProperty
    private final Integer startIndex;
    @Nullable
    @Attribute(description="An integer indicating the desired maximum number of query results per page")
    @JsonProperty
    private final Integer count;

    @JsonCreator
    public SearchRequest(@Nullable @JsonProperty(value="attributes") Set<String> attributes, @Nullable @JsonProperty(value="excludedAttributes") Set<String> excludedAttributes, @Nullable @JsonProperty(value="filter") String filter, @Nullable @JsonProperty(value="sortBy") String sortBy, @Nullable @JsonProperty(value="sortOrder") SortOrder sortOrder, @Nullable @JsonProperty(value="startIndex") Integer startIndex, @Nullable @JsonProperty(value="count") Integer count) {
        this.attributes = attributes;
        this.excludedAttributes = excludedAttributes;
        this.filter = filter;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.startIndex = startIndex;
        this.count = count;
    }

    @Nullable
    public Set<String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Set<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public String getSortBy() {
        return this.sortBy;
    }

    @Nullable
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.excludedAttributes != null ? !this.excludedAttributes.equals(that.excludedAttributes) : that.excludedAttributes != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        if (this.sortOrder != that.sortOrder) {
            return false;
        }
        return !(this.startIndex != null ? !this.startIndex.equals(that.startIndex) : that.startIndex != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.excludedAttributes != null ? this.excludedAttributes.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.sortBy != null ? this.sortBy.hashCode() : 0);
        result = 31 * result + (this.sortOrder != null ? this.sortOrder.hashCode() : 0);
        result = 31 * result + (this.startIndex != null ? this.startIndex.hashCode() : 0);
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        return result;
    }
}

