/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:ResourceType", name="Resource Type", description="SCIM 2.0 Resource Type Resource")
public class ResourceTypeResource
extends BaseScimResource {
    @Nullable
    @Attribute(description="The resource type name.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final String name;
    @Nullable
    @Attribute(description="The resource type's human readable description.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final String description;
    @Nullable
    @Attribute(description="The resource type's HTTP addressable endpoint relative to the Base URL; e.g., \"/Users\".", referenceTypes={"uri"}, isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final URI endpoint;
    @Nullable
    @Attribute(description="The resource types primary/base schema URI.", referenceTypes={"uri"}, isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private final URI schema;
    @Nullable
    @Attribute(description="A list of URIs of the resource type's schema extensions.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=SchemaExtension.class)
    private final Collection<SchemaExtension> schemaExtensions;

    public ResourceTypeResource(@Nullable String name, @Nullable String description, @Nullable URI endpoint, @Nullable URI schema) {
        this(name, name, description, endpoint, schema, null);
    }

    @JsonCreator
    public ResourceTypeResource(@Nullable @JsonProperty(value="id") String id, @Nullable @JsonProperty(value="name", required=true) String name, @Nullable @JsonProperty(value="description") String description, @Nullable @JsonProperty(value="endpoint", required=true) URI endpoint, @Nullable @JsonProperty(value="schema", required=true) URI schema, @Nullable @JsonProperty(value="schemaExtensions") Collection<SchemaExtension> schemaExtensions) {
        super(id);
        this.name = name;
        this.description = description;
        this.endpoint = endpoint;
        this.schema = schema;
        this.schemaExtensions = schemaExtensions == null ? null : Collections.unmodifiableList(new ArrayList<SchemaExtension>(schemaExtensions));
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public URI getSchema() {
        return this.schema;
    }

    @Nullable
    public Collection<SchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceTypeResource that = (ResourceTypeResource)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return !(this.schemaExtensions != null ? !this.schemaExtensions.equals(that.schemaExtensions) : that.schemaExtensions != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.schemaExtensions != null ? this.schemaExtensions.hashCode() : 0);
        return result;
    }

    public static class SchemaExtension {
        @NotNull
        @Attribute(description="The URI of a schema extension.", isRequired=true, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, referenceTypes={"uri"})
        private URI schema;
        @Attribute(description="A Boolean value that specifies whether the schema extension is required for the resource type. If true, a resource of this type MUST include this schema extension and include any attributes declared as required in this schema extension. If false, a resource of this type MAY omit this schema extension", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT)
        private boolean required;

        @JsonCreator
        public SchemaExtension(@NotNull @JsonProperty(value="schema", required=true) URI schema, @JsonProperty(value="required", required=true) boolean required) {
            this.schema = schema;
            this.required = required;
        }

        @NotNull
        public URI getSchema() {
            return this.schema;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaExtension that = (SchemaExtension)o;
            if (this.required != that.required) {
                return false;
            }
            return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
        }

        public int hashCode() {
            int result = this.schema != null ? this.schema.hashCode() : 0;
            result = 31 * result + (this.required ? 1 : 0);
            return result;
        }
    }
}

