/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.Address;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Entitlement;
import com.unboundid.scim2.common.types.Group;
import com.unboundid.scim2.common.types.InstantMessagingAddress;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.PhoneNumber;
import com.unboundid.scim2.common.types.Photo;
import com.unboundid.scim2.common.types.Role;
import com.unboundid.scim2.common.types.X509Certificate;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.net.URI;
import java.util.List;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:User", name="User", description="User Account")
public class UserResource
extends BaseScimResource {
    @Nullable
    @Attribute(description="Unique identifier for the User typically used by the user to directly authenticate to the service provider.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.SERVER)
    private String userName;
    @Nullable
    @Attribute(description="The components of the user's real name.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private Name name;
    @Nullable
    @Attribute(description="The name of the User, suitable for display to end-users. The name SHOULD be the full name of the User being described if known.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String displayName;
    @Nullable
    @Attribute(description="The casual way to address the user in real life, e.g.'Bob' or 'Bobby' instead of 'Robert'. This attribute SHOULD NOT be used to represent a User's username (e.g., bjensen or mpepperidge)", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String nickName;
    @Nullable
    @Attribute(description="A fully qualified URL to a page representing the User's online profile", isRequired=false, referenceTypes={"external"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private URI profileUrl;
    @Nullable
    @Attribute(description="The user's title, such as \"Vice President\".", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String title;
    @Nullable
    @Attribute(description="Used to identify the organization to user relationship. Typical values used might be 'Contractor', 'Employee', 'Intern', 'Temp', 'External', and 'Unknown' but any value may be used.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String userType;
    @Nullable
    @Attribute(description="Indicates the User's preferred written or spoken language.  Generally used for selecting a localized User interface. e.g., 'en_US' specifies the language English and country US.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String preferredLanguage;
    @Nullable
    @Attribute(description="Used to indicate the User's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String locale;
    @Nullable
    @Attribute(description="The User's time zone in the 'Olson' timezone database format; e.g.,'America/Los_Angeles'", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String timezone;
    @Nullable
    @Attribute(description="A Boolean value indicating the User's administrative status.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private Boolean active;
    @Nullable
    @Attribute(description="The User's clear text password. This attribute is intended to be used as a means to specify an initial password when creating a new User or to reset an existing User's password.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.WRITE_ONLY, returned=AttributeDefinition.Returned.NEVER, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String password;
    @Nullable
    @Attribute(description="E-mail addresses for the user. The value SHOULD be canonicalized by the Service Provider, e.g., bjensen@example.com instead of bjensen@EXAMPLE.COM. Canonical Type values of work, home, and other.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, multiValueClass=Email.class)
    private List<Email> emails;
    @Nullable
    @Attribute(description="Phone numbers for the User.  The value SHOULD be canonicalized by the Service Provider according to format in RFC3966 e.g., 'tel:+1-201-555-0123'.  Canonical Type values of work, home, mobile, fax, pager and other.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, multiValueClass=PhoneNumber.class)
    private List<PhoneNumber> phoneNumbers;
    @Nullable
    @Attribute(description="Instant messaging addresses for the User.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, multiValueClass=InstantMessagingAddress.class)
    private List<InstantMessagingAddress> ims;
    @Nullable
    @Attribute(description="URIs of photos of the User.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, multiValueClass=Photo.class)
    private List<Photo> photos;
    @Nullable
    @Attribute(description="Physical mailing addresses for this User.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, multiValueClass=Address.class)
    private List<Address> addresses;
    @Nullable
    @Attribute(description="A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=Group.class)
    private List<Group> groups;
    @Nullable
    @Attribute(description="A list of entitlements for the User that represent a thing the User has.", isRequired=false, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=Entitlement.class)
    private List<Entitlement> entitlements;
    @Nullable
    @Attribute(description="A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.", isRequired=false, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=Role.class)
    private List<Role> roles;
    @Nullable
    @Attribute(description="A list of certificates issued to the User.", isRequired=false, returned=AttributeDefinition.Returned.DEFAULT, multiValueClass=X509Certificate.class)
    private List<X509Certificate> x509Certificates;

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @NotNull
    public UserResource setUserName(@Nullable String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    public Name getName() {
        return this.name;
    }

    @NotNull
    public UserResource setName(@Nullable Name name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public UserResource setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    public String getNickName() {
        return this.nickName;
    }

    @NotNull
    public UserResource setNickName(@Nullable String nickName) {
        this.nickName = nickName;
        return this;
    }

    @Nullable
    public URI getProfileUrl() {
        return this.profileUrl;
    }

    @NotNull
    public UserResource setProfileUrl(@Nullable URI profileUrl) {
        this.profileUrl = profileUrl;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public UserResource setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getUserType() {
        return this.userType;
    }

    @NotNull
    public UserResource setUserType(@Nullable String userType) {
        this.userType = userType;
        return this;
    }

    @Nullable
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @NotNull
    public UserResource setPreferredLanguage(@Nullable String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    @NotNull
    public UserResource setLocale(@Nullable String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    @NotNull
    public UserResource setTimezone(@Nullable String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @NotNull
    public UserResource setActive(@Nullable Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public UserResource setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Nullable
    public List<Email> getEmails() {
        return this.emails;
    }

    @NotNull
    public UserResource setEmails(@Nullable List<Email> emails) {
        this.emails = emails;
        return this;
    }

    @NotNull
    public UserResource setEmails(@NotNull Email email, Email ... emails) {
        this.setEmails(StaticUtils.toList(email, emails));
        return this;
    }

    @Nullable
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @NotNull
    public UserResource setPhoneNumbers(@Nullable List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @NotNull
    public UserResource setPhoneNumbers(@NotNull PhoneNumber phoneNumber, PhoneNumber ... phoneNumbers) {
        this.setPhoneNumbers(StaticUtils.toList(phoneNumber, phoneNumbers));
        return this;
    }

    @Nullable
    public List<InstantMessagingAddress> getIms() {
        return this.ims;
    }

    @NotNull
    public UserResource setIms(@Nullable List<InstantMessagingAddress> ims) {
        this.ims = ims;
        return this;
    }

    @NotNull
    public UserResource setIms(@NotNull InstantMessagingAddress ims1, InstantMessagingAddress ... ims) {
        this.setIms(StaticUtils.toList(ims1, ims));
        return this;
    }

    @Nullable
    public List<Photo> getPhotos() {
        return this.photos;
    }

    @NotNull
    public UserResource setPhotos(@Nullable List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    @NotNull
    public UserResource setPhotos(@NotNull Photo photo, Photo ... photos) {
        this.setPhotos(StaticUtils.toList(photo, photos));
        return this;
    }

    @Nullable
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @NotNull
    public UserResource setAddresses(@Nullable List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    @NotNull
    public UserResource setAddresses(@NotNull Address address, Address ... addresses) {
        this.setAddresses(StaticUtils.toList(address, addresses));
        return this;
    }

    @Nullable
    public List<Group> getGroups() {
        return this.groups;
    }

    @NotNull
    public UserResource setGroups(@Nullable List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @NotNull
    public UserResource setGroups(@NotNull Group group1, Group ... groups) {
        this.setGroups(StaticUtils.toList(group1, groups));
        return this;
    }

    @Nullable
    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    @NotNull
    public UserResource setEntitlements(@Nullable List<Entitlement> entitlements) {
        this.entitlements = entitlements;
        return this;
    }

    @NotNull
    public UserResource setEntitlements(@NotNull Entitlement entitlement1, Entitlement ... entitlements) {
        this.setEntitlements(StaticUtils.toList(entitlement1, entitlements));
        return this;
    }

    @Nullable
    public List<Role> getRoles() {
        return this.roles;
    }

    @NotNull
    public UserResource setRoles(@Nullable List<Role> roles) {
        this.roles = roles;
        return this;
    }

    @NotNull
    public UserResource setRoles(@NotNull Role role1, Role ... roles) {
        this.setRoles(StaticUtils.toList(role1, roles));
        return this;
    }

    @Nullable
    public List<X509Certificate> getX509Certificates() {
        return this.x509Certificates;
    }

    @NotNull
    public UserResource setX509Certificates(@Nullable List<X509Certificate> x509Certificates) {
        this.x509Certificates = x509Certificates;
        return this;
    }

    @NotNull
    public UserResource setX509Certificates(@NotNull X509Certificate x509Certificate1, X509Certificate ... x509Certificates) {
        this.setX509Certificates(StaticUtils.toList(x509Certificate1, x509Certificates));
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserResource that = (UserResource)o;
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.nickName != null ? !this.nickName.equals(that.nickName) : that.nickName != null) {
            return false;
        }
        if (this.profileUrl != null ? !this.profileUrl.equals(that.profileUrl) : that.profileUrl != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.userType != null ? !this.userType.equals(that.userType) : that.userType != null) {
            return false;
        }
        if (this.preferredLanguage != null ? !this.preferredLanguage.equals(that.preferredLanguage) : that.preferredLanguage != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) {
            return false;
        }
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.emails != null ? !this.emails.equals(that.emails) : that.emails != null) {
            return false;
        }
        if (this.phoneNumbers != null ? !this.phoneNumbers.equals(that.phoneNumbers) : that.phoneNumbers != null) {
            return false;
        }
        if (this.ims != null ? !this.ims.equals(that.ims) : that.ims != null) {
            return false;
        }
        if (this.photos != null ? !this.photos.equals(that.photos) : that.photos != null) {
            return false;
        }
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.entitlements != null ? !this.entitlements.equals(that.entitlements) : that.entitlements != null) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        return !(this.x509Certificates == null ? that.x509Certificates != null : !this.x509Certificates.equals(that.x509Certificates));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.nickName != null ? this.nickName.hashCode() : 0);
        result = 31 * result + (this.profileUrl != null ? this.profileUrl.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.userType != null ? this.userType.hashCode() : 0);
        result = 31 * result + (this.preferredLanguage != null ? this.preferredLanguage.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
        result = 31 * result + (this.active != null ? this.active.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.emails != null ? this.emails.hashCode() : 0);
        result = 31 * result + (this.phoneNumbers != null ? this.phoneNumbers.hashCode() : 0);
        result = 31 * result + (this.ims != null ? this.ims.hashCode() : 0);
        result = 31 * result + (this.photos != null ? this.photos.hashCode() : 0);
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = 31 * result + (this.entitlements != null ? this.entitlements.hashCode() : 0);
        result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
        result = 31 * result + (this.x509Certificates != null ? this.x509Certificates.hashCode() : 0);
        return result;
    }
}

