/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.util.Arrays;

public class X509Certificate {
    @Nullable
    @Attribute(description="The value of a X509 certificate.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private byte[] value;
    @Nullable
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Nullable
    @Attribute(description="A label indicating the attribute's function.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Nullable
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @NotNull
    public X509Certificate setValue(@Nullable byte[] value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @NotNull
    public X509Certificate setDisplay(@Nullable String display) {
        this.display = display;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public X509Certificate setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public X509Certificate setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X509Certificate that = (X509Certificate)o;
        if (!Arrays.equals(this.value, that.value)) {
            return false;
        }
        if (this.display != null ? !this.display.equals(that.display) : that.display != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.primary == null ? that.primary != null : !this.primary.equals(that.primary));
    }

    public int hashCode() {
        int result = this.value != null ? Arrays.hashCode(this.value) : 0;
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }
}

