/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.server.utils.ServerUtils;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    @NotNull
    @Context
    private Request request;
    @NotNull
    @Context
    private HttpHeaders headers;

    @NotNull
    public Response toResponse(@NotNull RuntimeException exception) {
        ErrorResponse errorResponse;
        if (exception instanceof WebApplicationException) {
            if (exception.getCause() != null && exception.getCause() instanceof NoContentException) {
                errorResponse = new ErrorResponse(400);
                errorResponse.setScimType("invalidSyntax");
                errorResponse.setDetail("No content provided. A valid SCIM object represented as a json document is required");
            } else {
                errorResponse = new ErrorResponse(((WebApplicationException)exception).getResponse().getStatus());
                errorResponse.setDetail(exception.getMessage());
            }
        } else {
            errorResponse = new ErrorResponse(500);
            errorResponse.setDetail(exception.toString());
        }
        return ServerUtils.setAcceptableType(Response.status((int)errorResponse.getStatus()).entity((Object)errorResponse), this.headers.getAcceptableMediaTypes()).build();
    }
}

